package LCM::Task::DumpConfigfileTemplateProcessTask;

use strict;
use parent 'LCM::Task::SLProcessTask';
use LCM::Task::CLIProcessTaskMetadata;
use LCM::Task::DumpConfigfileTemplate::DumpConfigfileTemplateTask;

my $ACTION_DONE_MESSAGE = "Configuration file template created";
my $ACTION_FAILED_MESSAGE = "Creation of configuration file template failed.";
my $ACTION_ABORTED_MESSAGE = "Creation of configuration file template aborted.";

sub new {
    my ($class, $config, $app) = @_;
    my $self = $class->SUPER::new($config);
    $self->_setCLIMetadata(LCM::Task::CLIProcessTaskMetadata->new({
        requiresInput           => 0,
        requiresSummary         => 0,
        requiresConfirmation    => 0,
        requiresLog             => 0,
        messageBeforeConfirm    => undef,
    }));
    my $status = $self->getStatus();

    $status->_setActionDoneMessage($ACTION_DONE_MESSAGE);
    $status->_setActionFailedMessage($ACTION_FAILED_MESSAGE);
    $status->_setActionAbortedMessage($ACTION_ABORTED_MESSAGE);
    $self->_setApp($app);
    $self->_createSubtasks();

    return $self;
}

sub getId {
    return "dump_configfile_template_process_task";
}

sub getName {
    return "Dump configfile template";
}

sub getActionDone {
	return $ACTION_DONE_MESSAGE;
}

sub getActionFailed {
	return $ACTION_FAILED_MESSAGE;
}

sub getActionAborted {
	return $ACTION_ABORTED_MESSAGE;
}

sub _setApp {
    my ($self, $app) = @_;
    $self->{app} = $app;
}

sub _getApp {
    my ($self) = @_;
    return $self->{app};
}

sub _createSubtasks {
	my ($self) = @_;
    my $config = $self->_getConfiguration();
    my $app = $self->_getApp();
    $self->addSubtask(LCM::Task::DumpConfigfileTemplate::DumpConfigfileTemplateTask->new($config, $app));
}

## Don't gather SL Analytics data for this action
sub _startSLAnalyticsMonitor {
    return 1;
}

sub _stopSLAnalyticsMonitor {
    return 1;
}


1;
