package LCM::Task::GenericStackTask::ComponentExecutionFailedHandler;

use strict;
use parent 'LCM::Task::BaseSubtaskFailedHandler';
use SDB::Install::Globals qw ($gKeynameInstaller);

sub handle {
	my ($self, $task) = @_;
	my $parentTask = $task->getParentTask();
	my $installerKeyname = $gKeynameInstaller;
	my $taskIdInstall = "install_${installerKeyname}";
	my $taskIdUpdate = "update_${installerKeyname}";
	my $hdblcmComponentTask = $parentTask->getSubtaskById($taskIdUpdate) || $parentTask->getSubtaskById($taskIdInstall);
	my $isHdblcmUpdated = defined($hdblcmComponentTask) && $hdblcmComponentTask->getStatus()->isInFinishedState();

	$parentTask->getSubtasks(); # See implementation of getSubtasks in LCM::Task::GenericStackProcessTask
	for my $task ( @{ $parentTask->getAllSubtasks() } ) {
		if ( $task->getStatus()->isInInitialState() ) {
			next if($task->isUpdateHostTask() && $isHdblcmUpdated);
			next if($task->isUpdateLMStructureTask());

			$task->setSkipped(1);
		}
	}
	return 1;
}

sub isApplicable {
	my ($self, $task) = @_;
    return 1 if $task->isComponentTask() && !$task->isServerComponentTask();
    return 0;
}

1;
