package LCM::Task::GenericStackTask::DisableAutoFailoverTask;

use strict;
use parent 'LCM::Task';

sub getId {
    return 'disable_auto_failover';
}

sub getName{
    return 'Disable Auto-Failover';
}

sub getExecutionName{
    return 'Disabling Auto-Failover';
}

sub _executeInternal {
    my $self = shift;
    my $configuration = $self->_getConfiguration();
    my $instance = $configuration->getOwnInstance();
    return 0 if (!defined($instance));

    my $message = $self->getMsgLst()->addProgressMessage($self->getExecutionName(). "...");
    my $saveContext = $self->setMsgLstContext([$message->getSubMsgLst()]);

    if($instance->disableAutoFailover($self->getMsgLst())){
        $self->getStatus()->_setFinishedState();
        $message->endMessage (undef, sprintf("%s finished", $self->getName()));
    } else {
        $self->getStatus()->_setErrorState();
        $message->endMessage (undef, sprintf("%s failed", $self->getName()));
    }
    $self->setMsgLstContext($saveContext);
}

sub _getNumberOfExpectedOutputLines{
    return 0;
}

sub isHidden{
    return 1;
}

sub shouldBeShownOnSummaryPage {
    return 0;
}

1;
