package LCM::Task::GenericStackTask::Install::CollectHDBInstanceTask;

use strict;
use parent 'LCM::Task';
use SDB::Install::Globals qw($gShortProductNameEngine);

sub getId {
    return 'collect_hdb_instances';
}

sub getName{
    return "Collect $gShortProductNameEngine instance";
}

sub getExecutionName{
    return "Collecting $gShortProductNameEngine instance";
}

sub _executeInternal {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    $configuration->getOwnInstance(1);

    $self->getStatus()->_setFinishedState();
}

sub _getNumberOfExpectedOutputLines{
    return 0;
}

sub isHidden{
    return 1;
}

sub shouldBeShownOnSummaryPage {
  return 0;
}

1;
