package LCM::Task::GenericStackTask::MigrateSecureStoreTask;

use strict;
use warnings;
use parent 'LCM::Task';
use LCM::Task::TaskProgressHandler;

sub new {
    my ($class, $configuration, $target) = @_;
    my $self = $class->SUPER::new($configuration);
    $self->setTarget($target);
    return $self;
}

sub getId {
    return 'migrate_secure_store';
}

sub getName{
    my ($self) = @_;
    return "Migrate secure store to ".$self->getTarget();
}

sub getExecutionName{
    my ($self) = @_;
    return "Migrate secure store to ".$self->getTarget();
}

sub _executeInternal {
    my ($self) = @_;
    my $msg = $self->getMsgLst()->addProgressMessage($self->getExecutionName());
    my $saveCtx = $self->setMsgLstContext([$msg->getSubMsgLst(), $msg->getSubMsgLst()]);

    my $rc = $self->_migrateSecureStore();
    my $status = $self->getStatus();
    my $state = $rc ? $status->_setFinishedState() : $status->_setErrorState();

    $self->setMsgLstContext($saveCtx);
    return $rc;
}

sub _migrateSecureStore {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();
    my $instance = $configuration->getOwnInstance(1);
    if (!defined $instance) {
        $self->getErrMsgLst()->addError("Failed to get HDB instance");
        return undef;
    }
    return $instance->migrateSecureStore($self->getTarget(), $configuration, $self->getMsgLst());
}

sub _getNumberOfExpectedOutputLines{
    return 2;
}

sub shouldBeShownOnSummaryPage {
    return 0;
}

sub initProgressHandler {
    my ($self) = @_;
    $self->getMsgLst()->setProgressHandler(LCM::Task::TaskProgressHandler->new($self));
}

sub setTarget {
    my ($self, $target) = @_;
    $self->{target} = $target;
}

sub getTarget {
    my ($self) = @_;
    return $self->{target};
}

1;
