package LCM::Task::GenericStackTask::PostConfigurePhaseTaskGenerator;
use parent 'LCM::Task::TaskGenerator';
use strict;

use LCM::Task::ConvertToMultiDBTask::ConvertToMultiDBTask;
use LCM::Task::ConvertToMultiDBTask::InitializeSystemUserInMultiDbTask;
use LCM::Task::GenericStackTask::RemoveComponentPersistencies;
use LCM::Task::GenericStackTask::Install::CollectHDBInstanceTask;
use LCM::Task::GenericStackTask::MigrateSecureStoreTask;
use SDB::Install::Globals qw($gSecureStoreTypeLSS);

sub createTaskList{
    my($self, $configuration) = @_;
    my $result = [];
    if($configuration->isConvertToMultiDbRequired()){
        push(@$result,LCM::Task::ConvertToMultiDBTask::ConvertToMultiDBTask->new($configuration));
        if($configuration->shallInitializeSystemUserDuringConvertToMDC()){
            push(@$result,LCM::Task::ConvertToMultiDBTask::InitializeSystemUserInMultiDbTask->new($configuration));
        }
    }
    if($self->_isSecureStoreMigrationRequired($configuration)) {
        push (@$result, LCM::Task::GenericStackTask::MigrateSecureStoreTask->new($configuration, $gSecureStoreTypeLSS));
    }
    if(!$configuration->isUpdate()) {
# This is required in the case of phased installation because the HDB instance is created during the configure
# phase, and hdblcm has to know that it already exists from this point on.
        push(@$result, LCM::Task::GenericStackTask::Install::CollectHDBInstanceTask->new($configuration));
    }
    if($configuration->isServerNoStart()) {
        push(@$result, LCM::Task::GenericStackTask::RemoveComponentPersistencies->new($configuration));
    }
    return $result;
}

sub _isSecureStoreMigrationRequired {
    my ($self, $configuration) = @_;
 # hdbinst will do the migration
    return 0 if !$configuration->isUpdate();
# secure store is not set to be LSS
    return 0 if !$configuration->shallUseLSS();
# hdblcm must do the migration as it has to be done after the conversion to multidb
    return 1 if $configuration->isConvertToMultiDbRequired();

# hdbupd will do the migration if the server is selected
    return !$configuration->getComponentManager()->isHDBServerComponentSelected();
}

1;
