package LCM::Task::GenericStackTask::PostOnlinePhaseTaskGenerator;
use parent 'LCM::Task::TaskGenerator';
use strict;

use LCM::Task::ConvertToMultiDBTask::ConvertStreamingTask;
use SDB::Install::Globals qw($gKeynameStreaming $gKeynameEngine $gKeynameXS2);
use SDB::Install::Configuration qw($bool_true_pattern);
use LCM::Task::ConvertToMultiDBTask::StartTennantDatabaseTask;
use LCM::Task::ConvertToMultiDBTask::StartXSAServicesTask;
use LCM::Component::Installable::HDBServer::HDBServerBase;
use LCM::Utils::CommonUtils;

sub createTaskList{
    my($self, $configuration) = @_;
    my $result = [];
    my $mcm = $configuration->getComponentManager();
    my $scm = $configuration->getSystemComponentManager();
    my $server = $scm->getComponentByKeyName($gKeynameEngine);
    my $isConvertToMDCStarted = defined $server ? $server->isConvertToMDCStarted() : 0;
    my $isConvertToMDC = $configuration->isConvertToMultiDbRequired() || $isConvertToMDCStarted;
    my $isReplicationSystem = LCM::Utils::CommonUtils::isSystemReplication($configuration);
    if($isConvertToMDC && !$isReplicationSystem){
        push(@$result, LCM::Task::ConvertToMultiDBTask::ConvertStreamingTask->new($configuration)) if $configuration->hasStreaming();
        push(@$result, LCM::Task::ConvertToMultiDBTask::StartTennantDatabaseTask->new($configuration));

        my $isXs2Selected = $mcm->isComponentSelected($gKeynameXS2);
        my $isXs2Available = $scm->isComponentAvailable($gKeynameXS2);
        if($isXs2Available && !$isXs2Selected){
            push(@$result, new LCM::Task::ConvertToMultiDBTask::StartXSAServicesTask($configuration));
        }
    }
    return $result;
}

1;