package LCM::Task::GenericStackTask::RemoveOutdatedStatusFiles;

use strict;
use parent 'LCM::Task';

sub getId {
	return 'remove_outdated_status_files';
}

sub getName{
	return 'Remove Outdated Status Files';
}

sub getExecutionName{
	return 'Removing Outdated Status Files';
}

sub _executeInternal {
	my $self = shift;
	$self->removeOutdatedStatusFiles();
	$self->getStatus()->_setFinishedState();
}

sub removeOutdatedStatusFiles {
	my ($self) = @_;
	my $configuration = $self->_getConfiguration();
	my $sid = $configuration->getSID();
	my $currSystem = $configuration->getSAPSystem();

	require LCM::Configuration::GenericStackInstallConfiguration;
	my $config = new LCM::Configuration::GenericStackInstallConfiguration();
	$config->{current_sid} = $sid;
	$config->{params}->{Target}->{value} = $currSystem->get_target();
	if ( $config->pers_exists() ) {
		$config->pers_remove($config->pers_filename());
	}
}

sub _getNumberOfExpectedOutputLines{
    return 0;
}

sub isHidden{
	return 1;
}

sub shouldBeShownOnSummaryPage {
    return 0;
}

1;
