package LCM::Task::PrintComponentListProcessTask;

use strict;
use parent 'LCM::Task::SLProcessTask';
use LCM::Task::CLIProcessTaskMetadata;
use LCM::Task::ComponentList::PrintComponentListTask;

sub new {
    my ($class, $config) = @_;
    my $self = $class->SUPER::new($config);
    $self->_setCLIMetadata(LCM::Task::CLIProcessTaskMetadata->new({
        requiresInput           => 1,
        requiresSummary         => 0,
        requiresConfirmation    => 0,
        requiresLog             => 0,
        requiresHeaderMessage   => 0,
        messageBeforeConfirm    => undef,
    }));
    $self->_addSubtasks();
    return $self;
}

sub getId {
    return "print_component_list_process_task";
}

sub getName {
    return "Print component list";
}

sub _addSubtasks {
    my ($self) = @_;
    my $config = $self->_getConfiguration();
    $self->addSubtask(LCM::Task::ComponentList::PrintComponentListTask->new($config));
}

## Don't gather SL Analytics data for this action
sub _startSLAnalyticsMonitor {
    return 1;
}

sub _stopSLAnalyticsMonitor {
    return 1;
}

1;