package LCM::Task::RemoveHostsProcessTask;

use strict;
use parent qw(LCM::Task::SLProcessTask);
use LCM::Task qw($gFlavourProductName);
use LCM::Task::Hosts::RemoveHosts::UpdateHostsTaskListFactory;
use LCM::Task::Hosts::RemoveHosts::RemoveLocalHostTask;
use LCM::Task::CommonTask::RemoveRemoteHostsTask;
use LCM::Task::CommonTask::UpdateComponentListOnLocalHostTask;
use LCM::Task::CommonTask::UpdateComponentListTask;


my $ACTION_DONE_MESSAGE = "Hosts removed from the $gFlavourProductName System";
my $ACTION_FAILED_MESSAGE = "Removal of hosts from the $gFlavourProductName System failed.";
my $ACTION_ABORTED_MESSAGE = "Removal of hosts from the $gFlavourProductName System aborted.";
my $ACTION_DONE_WITH_WARNINGS_MESSAGE = "Hosts removed from the $gFlavourProductName System with warnings.";

sub new{
    my ($class, $configuration) = @_;
    my $self = $class->SUPER::new($configuration);
    my $status = $self->getStatus();

    $status->_setActionDoneMessage($self->_formatMessage($ACTION_DONE_MESSAGE));
    $status->_setActionDoneWithWarningsMessage($self->_formatMessage($ACTION_DONE_WITH_WARNINGS_MESSAGE));
    $status->_setActionFailedMessage($self->_formatMessage($ACTION_FAILED_MESSAGE));
    $status->_setActionAbortedMessage($self->_formatMessage($ACTION_ABORTED_MESSAGE));

    return $self;
}

# Override
sub getId {
    return "remove_hosts";
}

# Override
sub getName {
    return "Remove Hosts";
}

# Override
sub _executeInternal {
    my $self = shift();
    $self->_createSubtasks();
    $self->SUPER::_executeInternal(@_);
}

sub _createSubtasks {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();

    my $isRemovingLocalHost = $self->_isRemovingLocalHost();
    my $isRemovingRemoteHosts = $self->_isRemovingRemoteHost();

    my $updateHostsFactory = new LCM::Task::Hosts::RemoveHosts::UpdateHostsTaskListFactory ($configuration);
    $self->addSubtask($updateHostsFactory->createUpdateLocalHostTask()) if ($isRemovingLocalHost);
    $self->addSubtask($updateHostsFactory->createUpdateRemoteHostsTask($configuration->getRemoteHostsMarkedForRemoval())) if($isRemovingRemoteHosts);
    $self->addSubtask(new LCM::Task::CommonTask::RemoveRemoteHostsTask($configuration)) if($isRemovingRemoteHosts);
    $self->addSubtask(new LCM::Task::CommonTask::UpdateComponentListTask($configuration)) if($isRemovingRemoteHosts);
    $self->addSubtask(new LCM::Task::Hosts::RemoveHosts::RemoveLocalHostTask($configuration)) if($isRemovingLocalHost);
    $self->addSubtask(new LCM::Task::CommonTask::UpdateComponentListOnLocalHostTask($configuration)) if($isRemovingLocalHost);
   	
}

sub _isRemovingLocalHost {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();

    return $configuration->isLocalhostMarkedForRemoval();
}

sub _isRemovingRemoteHost {
    my ($self) = @_;
    my $configuration = $self->_getConfiguration();

    return $configuration->isRemoteHostsMarkedForRemoval();
}

1;