package LCM::Task::RenameTask::UpdateRemoteHostsAfterRenameTask;

use strict;
use parent qw(LCM::Task::CommonTask::UpdateRemoteHostsTask);

use LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::RemoteComponentsManager;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::SkippedComponentsManager qw ( $SCENARIO_RENAME );

sub new {
    my ($class, $configuration) = @_;
    my $configAfterRename = _createRemoteConfigurationAfterRenameConfig($configuration);
    my $self = $class->SUPER::new($configAfterRename);
    return $self;
}

# Override
sub getId {
    return 'update_remote_hosts_after_rename';
}

sub _createRemoteConfigurationAfterRenameConfig{
    my ($configuration) = @_;
    my $sid                = $configuration->getValue('newSID');
    my $sharedDir          = $configuration->getValue('Target');
    my $sidAdmPassword     = $configuration->getValue('Password');
    my $shallDeployShaConfigurations = ($configuration->shouldSkipHostagentCalls()) ? 0 : 1;
    my $paramHash = {
        ComponentsRegistration      => $configuration->shallReregisterComponents() ? 'register' : undef,
        GenerateCertificates        => $shallDeployShaConfigurations, # no point in generating certs if won't deploy
        DeployShaConfigurations     => $shallDeployShaConfigurations,
        UpdateComponentListLocation => 0,
        SkippedComponents           => getSkippedComponentsForRemoteRegistration($configuration),
        SpecificHosts               => undef
    };
    return LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory->createRemoteConfigurationAfterRename
                    ($sharedDir, $sid, $sidAdmPassword, $configuration, $paramHash);
}

sub getSkippedComponentsForRemoteRegistration{
    my ($configuration) = @_;
    my $componentManager    = $configuration->getSystemComponentManager();
    my $installedComponents = $componentManager->getAllComponents();
    my $componentsRegistrationMgr = new LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::RemoteComponentsManager
            ([], $installedComponents, $SCENARIO_RENAME); 
    $componentsRegistrationMgr->detectComponents();
    return $componentsRegistrationMgr->getSkippedComponents();
}

sub shouldBeShownOnSummaryPage {
    return 1;
}

1;