package LCM::Task::RenameTask::UpdateRemoteHostsBeforeRenameTask;

use strict;
use parent qw(LCM::Task::CommonTask::UpdateRemoteHostsTask);

use Cwd 'abs_path';
use File::Basename;
use LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory;

sub new {
    my ($class, $configuration) = @_;
    my $configBeforeRename = _createUpdateRemoteHostsBeforeRenameConfig($configuration);
    my $self = $class->SUPER::new($configBeforeRename);
    return $self;
}

# Override
sub getId {
    return 'update_remote_hosts_before_rename';
}

sub _createUpdateRemoteHostsBeforeRenameConfig{
    my ($configuration) = @_;
    my $realPathToHanaSharedSid = abs_path( $configuration->getHanaSharedSidFromHdblcmRuntimeDir() );
    my $sourceSid               = basename($realPathToHanaSharedSid);
    my $sharedDir               = $configuration->getHanaSharedFromHdblcmRuntimeDir();
    my $paramHash = {
        ComponentsRegistration      => 'unregister',
        GenerateCertificates        => 0,
        DeployShaConfigurations     => 0,
        UpdateComponentListLocation => 0,
        SpecificHosts => undef
    };
    return LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory->createRemoteConfigurationBeforeRename
                        ($sharedDir, $sourceSid, $configuration, $paramHash);
}

sub shouldBeShownOnSummaryPage {
    return 1;
}

1;