package LCM::Task::StartStopHostsTask::StartSpecificHostsTask;

use strict;

use parent 'LCM::Task::StartStopHostsTask::StartStopSpecificHostsTaskBase';

use SDB::Install::SAPInstance::TrexInstance;

sub getId {
	my ($self) = @_;
	return 'start_instances';
}

sub getName {
	my ($self) = @_;
	return 'Start instances';
}

sub getExecutionName {
	my ($self) = @_;
	return 'Starting instances';
}

sub _manageSystem {
	my ($self, $hdbInstance, $userName, $password, $startTimeout, $stopTimeout, $useHttps) = @_;
	return $hdbInstance->startHosts ($userName,
	                                 $password,
	                                 $self->getHosts(),
	                                 $startTimeout,
	                                 $useHttps);
}

1;
