package LCM::Task::StartStopHostsTask::StopSystemTask;

use strict;

use parent 'LCM::Task::StartStopHostsTask::StartStopHostsTaskBase';

use SDB::Install::SAPInstance::TrexInstance;

sub getId {
	return 'stop_system';
}

sub getName {
	return 'Stop system';
}

sub getExecutionName {
	return 'Stopping system';
}

sub _manageSystem {
	my ($self, $hdbInstance, $userName, $password, $starTimeout, $stopTimeout, $useHttps) = @_;
	return $hdbInstance->stopAllHosts ($userName,
	                                   $password,
	                                   undef, # ignore not running nodes
	                                   $stopTimeout,
	                                   $useHttps);
}

1;
