package LCM::Task::UnregisterProcessTask;

use strict;
use File::Spec;
use parent 'LCM::Task::SLProcessTask';
use LCM::ExecutionWarningsObservable;
use LCM::Task::Unregister::UnregisterSubtask;
use SDB::Install::Globals qw($gLogDir);
use LCM::Task qw($gFlavourProductName $gActionScope);

my $ACTION_DONE_MESSAGE_TEMPLATE = "$gFlavourProductName $gActionScope unregistered";
my $ACTION_FAILED_MESSAGE_TEMPLATE = "Unregistration of $gFlavourProductName $gActionScope failed.";
my $ACTION_ABORTED_MESSAGE_TEMPLATE = "Unregistration of $gFlavourProductName $gActionScope aborted.";
my $ACTION_DONE_WITH_WARNINGS_MESSAGE_TEMPLATE = 'Unregistration of $gFlavourProductName $gActionScope finished with warnings';

my $UNREGISTER_NAME = "Unregister the $gFlavourProductName $gActionScope";

sub new {
	my ($class, $configuration) = @_;
	my $self = $class->SUPER::new($configuration);

	my $status = $self->getStatus();
	$status->_setActionDoneMessage($self->_formatMessage($ACTION_DONE_MESSAGE_TEMPLATE));
	$status->_setActionDoneWithWarningsMessage($self->_formatMessage($ACTION_DONE_WITH_WARNINGS_MESSAGE_TEMPLATE));
	$status->_setActionFailedMessage($self->_formatMessage($ACTION_FAILED_MESSAGE_TEMPLATE));
	$status->_setActionAbortedMessage($self->_formatMessage($ACTION_ABORTED_MESSAGE_TEMPLATE));

	$self->addSubtask(new LCM::Task::Unregister::UnregisterSubtask($configuration));

	return $self;
}

sub getId {
	my ($self) = @_;
	my $configuration = $self->_getConfiguration();
	my $scope = lc($configuration->getScope());

	return "unregister_$scope";
}

sub getName {
    return $_[0]->_formatMessage($UNREGISTER_NAME);
}

sub _executeInternal {
	my $self = shift();
	LCM::ExecutionWarningsObservable->getInstance()->registerListener($self);
	$self->SUPER::_executeInternal(@_);
	LCM::ExecutionWarningsObservable->getInstance()->unregisterListener($self);
}

#implementing required interface by LCM::ExecutionWarningsObservable
sub onWarning {
	my ($self,$message) = @_;
	$self->_addWarningMessage($message);
}

1;