package LCM::Task::UpdateHostProcessTask;

use strict;
use parent qw(LCM::Task::SLProcessTask);
use Exporter;
use LCM::Task::CommonTask::UpdateLocalHostTask;
use SDB::Install::Globals qw($gProductNameSystem);

sub new {
    my ($class, $config) = @_;
    my $self = $class->SUPER::new($config);
    my $subtask = LCM::Task::CommonTask::UpdateLocalHostTask->new($config);
    $self->addSubtask($subtask);

    my $status = $self->getStatus();
    $status->_setActionDoneMessage($subtask->getStatus()->_getActionDoneMessage());
    $status->_setActionFailedMessage($subtask->getStatus()->_getActionFailedMessage());
    $status->_setActionAbortedMessage($subtask->getStatus()->_getActionAbortedMessage());
    return $self;
}

sub getId {
    return "update_local_host_process_task";
}

sub getName {
    return "Update $gProductNameSystem";
}

## Don't gather SL Analytics data for this action
sub _startSLAnalyticsMonitor {
    return 1;
}

sub _stopSLAnalyticsMonitor {
    return 1;
}

1;