package LCM::XSAdminClient;
use strict;
use parent qw (LCM::XSAClient);
use SDB::Install::OutputHandler::NoOutHndlr;

sub new{
    my ($class, $instPath, $sid) = @_;
    my $self = shift->SUPER::new(@_);
    my $sidadm = SDB::Install::NewDBUser->new($sid);
    $self->executeAs($sidadm);
    return $self;
}

sub getParameterValue{
    my ($self,$parameter) = @_;
    if (!$self->_executeXSCommand(undef, ["--$parameter"], undef, $self->getOutputHandler())) {
        $self->getErrMsgLst()->addError("Failed to retrieve $parameter");
        return undef;
    }

    my $outputLines = $self->getOutputLines();
# We expect that the output of xs-admin-login is a single-line string. It is the same if we read the first or the last entry
# as they are the same line. Here we read the last line because when the tool is started via the SAPHOSTAGENT and the environment
# contains a variable with multi-line value, bash errors appear in the beginning and the actual result is in the end
    return @{$outputLines} ? $outputLines->[-1] : undef;
}

sub _getExecutable{
    my ($self) = @_;
    my $instPath = $self->getInstallationPath();
    return File::Spec->catfile($instPath,'bin','xs-admin-login');
}

sub getOutputHandler{
    my $self = shift;
    $self->{handler} = SDB::Install::OutputHandler::NoOutHndlr->new() if(!defined $self->{handler});
    return $self->{handler};
}

sub _createXsProcessExecutor {
    my ($self, $command, $args, $stdin) = @_;
    my $executor = shift->SUPER::_createXsProcessExecutor(@_);
    my $env = $self->getExecutionOSUser()->getSidAdm()->getInitialEnvironment();
    $executor->setProcessEnvironment ($env);
    return $executor;
}

1;
