#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 

package SAPDB::Install::Control::PathCtrl;

use Wx qw (	wxHORIZONTAL
			wxDD_NEW_DIR_BUTTON
			wxALIGN_CENTER_VERTICAL
			wxID_OK);
use Wx::Event qw(EVT_BUTTON EVT_TEXT);
use SAPDB::Install::Resources;
use SDB::Install::Gui::Design;
use strict;

our @ISA = ('Wx::Panel');

our $bitmap_folder;

sub new{
	my ($class, $parent, $id, $value, @args) = @_;

	my ($this ) = $class->SUPER::new ($parent, $id, @args);

	if ($^O !~ /mswin/i){
		$this->SetBackgroundColour (SDBBGCOLOUR_WizardDialog);
	}

	$bitmap_folder = Wx::Bitmap->new(new SAPDB::Install::Resources()->
        getImages('icon/folder.png')->{'icon/folder.png'});
	my $sizer = Wx::BoxSizer->new(wxHORIZONTAL);
	my $size = $args[1];
	my $text_width = -1;
	if (defined $size){
		if (ref ($size) eq 'ARRAY'){
			$text_width = $size->[0];
		}
		else{
			$text_width = $size->GetWidth ();
		}
	}
	if ($text_width > 0){
		$text_width -= $bitmap_folder->GetWidth ();
	}
	$this->{'edit'} = Wx::TextCtrl->new($this,-1,$value);
	$this->{'button'} = Wx::BitmapButton->new($this,-1,$bitmap_folder,[0,0],[-1,-1]);
	if ($text_width > 0){
		$text_width -= $this->{'button'}->GetSize()->GetWidth ();
		$this->{'edit'}->SetMinSize ([$text_width,-1]);
	}

	$sizer->Add($this->{'edit'},1,wxALIGN_CENTER_VERTICAL);
	$sizer->Add($this->{'button'});
	EVT_BUTTON($this,$this->{'button'}->GetId,
		sub {
			my ($self,$evt) = @_;
			
			my $dirdlg;
			if (!$this->{file}) {
				$dirdlg = new Wx::DirDialog ($self,'Choose a directory',$self->{'edit'}->GetValue,wxDD_NEW_DIR_BUTTON);				
			} else {
				$dirdlg = new Wx::FileDialog ($self,'Choose a file',$self->{'edit'}->GetValue);	
			}
			my $dir = $self->{'edit'}->GetValue();
			#$dir = getRealPathName($dir) if $^O =~ /mswin/i;
			$dirdlg->SetPath($dir);
			my $rc = $dirdlg->ShowModal;
			my $result = $dirdlg->GetPath if ($rc eq wxID_OK);
			#$result =~ s/\\/\//g  unless $^O =~ /mswin/i;
			#$result = getRealPathName($result) if $^O =~ /mswin/i;
			$self->{'edit'}->SetValue($result) if defined $result && ($result =~ /\S/);
		}
	);

	EVT_TEXT ($this,$this->{'edit'}->GetId(),
		sub{
			my ($self,$evt) = @_;
			$evt->SetId ($self->GetId);
			$self->AddPendingEvent ($evt);
		}
	);

	$this->{file} = 0;
	
	$this->SetSizerAndFit($sizer);
	$this->SetAutoLayout(1);
	$this->Layout;
	return $this;
}

sub selectFile() {
	$_[0]->{file} = 1;
}

sub SetFocus {
	my $this = shift;
	$this->{'edit'}->SetFocus();
}

sub Destroy{
	my ($self) = @_;
	if(defined $self->GetSizer){
		$self->GetSizer->Clear (1);
	}
	
	if(defined $self->{'button'}){
		delete $self->{'button'};
	}
	
	if(defined $self->{'edit'}){
		delete $self->{'edit'};
	}
	$self->SUPER::Destroy;
}

sub SetValue{
	my ($self,$value) = @_	;
	#$value = getRealPathName($value) if $^O =~ /mswin/i;
	$self->{'edit'}->SetValue($value);
	return 1;
}

sub Show{
	my ($self,$show) = @_;
	$self->{'edit'}->Show($show);
	$self->{'button'}->Show($show);	
	$self->SUPER::Show($show);
}
	

sub GetValue{
	my ($self) = @_	;
	my $value = $self->{'edit'}->GetValue();
		
	#
	#	remove trailing slashes / backslashes
	#
	
	#$value =~ s/\\/\//g;		
	#$value =~ s/[\/]*$//;
	
	#
	#	remove doubled slashes / backslashes (not at the begin -> unc path)
	#
	
	if ($^O =~ /mswin/i){
		#$value = getRealPathName ($value);
	}
	else{
		$value =~ s/\/{2,}/\//g;
	}
	
	return $value;
}

sub DESTROY{
	my ($self) =  @_;
	print ">>>> DESTROY $self\n"
		if defined $SAPDB::Install::DEBUG::DESTRUCT &&
			$SAPDB::Install::DEBUG::DESTRUCT;
}


1;
