#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: start SAP DB installation/update/patch/instanceupgrade, called by SDBINST/SDBUPD

package SAPDB::Install::Frame::Base;

use Wx qw (wxYES_NO wxCENTRE wxID_YES
	wxICON_QUESTION wxNO_DEFAULT wxBITMAP_TYPE_ICO_RESOURCE
	wxBITMAP_TYPE_ICO);

use Wx::Event qw (EVT_CLOSE);

use strict;

use SAPDB::Install::Resources;
use SDB::Install::Tools qw (callstack);

our @ISA = qw (Wx::Frame);


our $icon;

sub new {
	my( $class ) = shift;
	my( $this ) = $class->SUPER::new( undef, -1, @_ );
  

	if ($^O =~ /mswin/i){

		#
		# load icon from the executable file
		# TODO: load it as wxBITMAP_TYPE_ICO_RESOURCE from the resource db directly
		#

        if ($SAPDB::Install::Config{RuntimeDir}){
            my $appdir = $SAPDB::Install::Config{RuntimeDir};

            $appdir =~ s/[\\\/]+instruntime[\\\/]*$//;

            my $exe = "$appdir\\hdbsetup.exe";
            if (!-f $exe){
                $exe = "$appdir\\..\\bin\\hdblaunch.exe";
            }

            if (-f $exe){
                my $l = new Wx::LogNull(); # suppress error popup 
                $icon = new Wx::Icon ($exe,wxBITMAP_TYPE_ICO);
            }
        }
		if (!defined $icon || !$icon->Ok()){
			$icon = Wx::Icon->new();
			$icon->CopyFromBitmap(Wx::Bitmap->new(SAPDB::Install::Resources->new()->
				getImages('icon/install.png')->{'icon/install.png'}));
		}
	}
	else{
		$icon = Wx::Icon->new();
		unless(Wx::wxX11){
			$icon->CopyFromBitmap(Wx::Bitmap->new(SAPDB::Install::Resources->new()->
				getImages('icon/install.png')->{'icon/install.png'}));
		}
	}

	# load an icon and set it as frame icon
	$this->SetIcon($icon);
	$this->{'IsBeingClosed'} = 0;

	EVT_CLOSE( $this, \&OnQuit );
	$this;
}


sub OnQuit {
	my ($this,$event) = @_;
	unless ($event->CanVeto){
		$this->Destroy;
		return;
	}
	
	my $title = $this->GetTitle;
	$title =~ s/\s*\[.*\].*//; 
	my $msgbox = Wx::MessageDialog->new($this,
				"Do you really want to leave the $title?",
			"Exit?", wxYES_NO | wxNO_DEFAULT  | wxICON_QUESTION | wxCENTRE);
	if ( $msgbox->ShowModal() == wxID_YES){
		my $frames = callstack ();
		if(@$frames > 12){
			# not triggered by main loop (callback Wx::Yield())
			# abort current work by an exception
			die ('__SIGINT__');
		}
		$this->Destroy();
	}
	else{
		$event->Veto();
	}
}

1;
