#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 


package SAPDB::Install::ProcState;

bootstrap SAPDB::Install::ProcState;

require Exporter;
our @ISA = qw(Exporter);

our @EXPORT = qw (SDB_PROCSTATE_FLAG_MODULES SDB_PROCSTATE_FLAG_SOCKETS);

our $init_pid = $^O =~ /mswin/i ? 0 : 1;


sub isRoot ($$);

*isRoot = $^O =~ /mswin/i ?

sub ($$) {
	return $_[0] == 0;
}
:
sub ($$) {
	return $_[1] == 0;
};


sub addPid ($$$);
sub printTree ($$$);
sub findNode ($$$);
sub getChildren ($$$$);

sub addPid ($$$){
	my ($self, $pid, $visited) = @_;
	
	if (defined $visited->{$pid}){
		return $visited->{$pid};
	}
	
	
	my $ppid = $self->GetPPid ($pid);
	my $node;
	my $parent_node;
	
	if (isRoot ($pid,$ppid)){
		#root
		if (!defined $self->{tree}){
			$self->{tree} = {}
		}
		$parent_node = $self->{tree};
	}
	else{
		if (!defined $ppid){
			$ppid = $init_pid;
		}
		$parent_node = addPid ($self,$ppid,$visited);
	}
	
	$parent_node->{$pid} = {};
	$visited->{$pid} = $parent_node->{$pid};
	return $parent_node->{$pid};
}

sub getTree{
	my ($self) = @_;
	
	if (! defined $self->{tree}){
		my $visited = {};
		foreach my $proc (@{$self->{procs}}){
			addPid ($self,$proc->{pid},$visited);
		}
	}
	
	return $self->{tree};			
}

sub printTree ($$$) {
	my ($self,$node,$indent) = @_;
	
	if (!defined $node) {
		$node = $self->{tree};
	}
	my $cmd; 
	foreach my $pid (sort keys(%$node)){
		$cmd = $self->GetCmd ($pid);
		print "$indent $pid (". ($cmd ? $cmd : 'GONE' ) .")\n";
		printTree ($self,$node->{$pid},$indent . '   ');
	}
}


sub findNode ($$$){
    my ($self,$pid,$node) = @_;
    if (!defined $node) {
        $node = $self->{tree};
    }
    if (exists $node->{$pid}){
        return $node->{$pid};
    }
    my $result;
    foreach my $child (values (%$node)){
        $result = findNode ($self, $pid, $child);
        if (defined $result){
            return $result;
        }
    }
    return undef;
}


sub getChildren ($$$$) {
    my ($self,$pid,$find_childrens_children, $node) = @_;
    if (!defined $node){
        $node = findNode ($self, $pid, undef);
    }
    if (!defined $node){
        return undef;
    }
    if (!defined $find_childrens_children){
        $find_childrens_children = 0; # default off
    }
    if (!$find_childrens_children){
        return [keys %$node];
    }
    my @children = keys %$node;
    my $tmpResult;
    foreach my $childnode (values %$node){
        $tmpResult = getChildren ($self, undef, $find_childrens_children, $childnode);
        if (defined $tmpResult){
            push @children, @$tmpResult;
        }
    }
    return \@children;
}


sub AUTOLOAD {
	die "cannot load symbol ".$AUTOLOAD."\n"
		unless ($AUTOLOAD =~ /bootstrap$/);

	require XSLoader;
	XSLoader::load (__PACKAGE__);
}

1;