#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 

package SAPDB::Install::System::Check;

require Exporter;

our @ISA = qw (Exporter);
our @EXPORT = qw (check_mmap);

sub check_mmap{
	return 0,['not supported on this platform']  if ($^O =~ /mswin/);
	my ($fsnode,$size,$prot,$flags,$off) = @_;
	my @msgbuf;
	return 0,["directory $fsnode not found: $!"] unless (-e $fsnode);
	my $filename;
	my $rc = 0;
	require SAPDB::Install::System::Unix;
	import SAPDB::Install::System::Unix;
		
	if (-d $fsnode){
		$filename = "$fsnode/check_mmap";
		if (-f $filename){
			push @msgbuf,"file $filename already exists";
			if (unlink ($filename)){
				push @msgbuf,"file $filename deleted";
			}
		}	
	}
	else{
		push @msgbuf, "file $fsnode is no directory";
		return 0,\@msgbuf;
	}
	
	$size = (not defined $size or $size =~ /\D/ or $size == 0) ? 1024 : $size;
	$prot = defined $prot ? $prot : &PROT_WRITE;	
	$flags = defined $flags ? $flags : &MAP_SHARED;
	$off = defined $off ? $off : 0;
		
	if (open (FH,'+>'.$filename)){
		push @msgbuf, "file $filename created";
	}
	else{
		push @msgbuf, "cannot create file $filename: $!";
		return 0,\@msgbuf;
	}
	my $buf;
	
	if (defined mmap ($buf,$size,$prot,$flags,FH,$off)){
		$rc = 1;
		push @msgbuf,"mmap() returned with success";
		unless (defined munmap ($buf,$size)){
			push @msgbuf, "munmap() failed: $!";
			close (FH);
			unlink ($filename);
			return 0,\@msgbuf;
		}
		push @msgbuf,"munmap() returned with success";
	}
	else{
		push @msgbuf, "mmap() failed: $!";
	}
	close (FH);
	unlink ($filename);	
	return ($rc,\@msgbuf);			
}




1;
