package SDB::Common::BuiltIn;

use strict;
use warnings;

our $instance = undef;

=item get_instance()
Trying to implement the singleton pattern.
=cut

sub get_instance {
    if( !defined $instance ) {
        my $class = shift;
        $instance = {};
        bless $instance, $class;
    }

    return $instance;
};

=pod
Maintain alphabetical order of the methods.
=cut

sub chmod {
    my($self,$mode,$fileName) = @_;
    return CORE::chmod($mode, $fileName);
}

sub chown {
    my ($self, $uid, $gid, @filelist) = @_;
    return CORE::chown($uid // -1, $gid // -1, @filelist);
}

sub crypt {
    my ($self, $passwd, $salt) = @_;
    return CORE::crypt($passwd, $salt);
}

sub endgrent {
    return CORE::endgrent();
}

sub endpwent {
    return CORE::endpwent();
}

sub getgrgid {
    my $self = shift;
    if( wantarray ) {
        return CORE::getgrgid($_[0]);
    }
    my $retval = CORE::getgrgid($_[0]);
    return $retval;
}

sub getgrnam {
    my $self = shift;
    if( wantarray ) {
        return CORE::getgrnam($_[0]);
    }
    my $retval = CORE::getgrnam($_[0]);
    return $retval;
}

sub getgrent {
    my $self = shift;
    if( wantarray ) {
        return CORE::getgrent();
    }
    my $retval = CORE::getgrent();
    return $retval;
}

sub getpwent {
    my $self = shift;
    if( wantarray ) {
        return CORE::getpwent();
    }
    my $retval = CORE::getpwent();
    return $retval;
}

sub getpwnam {
    my $self = shift;
    if( wantarray ) {
        return CORE::getpwnam($_[0]);
    }
    my $retval = CORE::getpwnam($_[0]);
    return $retval;
}

sub getpwuid {
    my $self = shift;
    if( wantarray ) {
        return CORE::getpwuid($_[0]);
    }
    my $retval = CORE::getpwuid($_[0]);
    return $retval;
}

sub print{
   my $self = shift;
   return CORE::print($_[0]);
}

sub printf{
   my $self = shift;
   return CORE::printf(@_);
}

sub rename {
    my ($self, $oldPath, $newPath) = @_;
    return CORE::rename($oldPath, $newPath);
}

sub setgrent {
    return CORE::setgrent();
}

sub setpwent {
    return CORE::setpwent();
}

sub sleep {
    return CORE::sleep($_[1]);
}

sub symlink {
    my($self, $oldFile , $newFile) = @_;
    return CORE::symlink($oldFile , $newFile);
}

sub unlink {
    return CORE::unlink(@_);
}

1;

