#!/usr/bin/perl
#
# Desc: Performs network reconfiguration at a remote host caused by hdbmodify.
#       The main method is called by SDB::Install::RemoteHosts::executeParallel
#
# Like hdbrename, the tool repairs the detected configuration problems.


package SDB::Install::App::Console::HdbModifyHost;

use base SDB::Install::App::Console::HdbRegHost;
use SAPDB::Install::Hostname qw(hostname);

use strict;


#-------------------------------------------------------------------------------
# Constructor
sub new {

    my $self = shift->SUPER::new ();

    return $self;
}


#-------------------------------------------------------------------------------
# Returns the name of this program

sub getProgramName {
    return 'hdbmodify_' . lc(hostname());
}


#-------------------------------------------------------------------------------
# Initializes the program and performs several checks.
# Without parameters
# Returns undef in case of an error

sub init {

    my ($self) = @_;

    $self->{action}            = 'Reconfigure';
    $self->{actionProgressive} = 'Reconfiguring';
    $self->{actionDone}        = 'reconfigured';

    return $self->SUPER::init();
}

sub shouldWarnIfCalledStandalone{
    return 0;
}


#-------------------------------------------------------------------------------
# Returns true if the instance should be started after this instance
# is registered.

sub isStartInstance {
    return 0;
}


#===============================================================================
#   M A I N

sub main{
    my $app = new __PACKAGE__;
    return $app->mainFunction(\@_);
}


1;
