package SDB::Install::App::Console::LSS::RemoveHost;
use parent qw(SDB::Install::App::Console);

use strict;
use warnings;

use Getopt::Long;
use SDB::Install::LSS::LssInstance;
use SDB::Install::SAPSystem qw ( CollectSAPSystems );
use SDB::Install::System qw(deltree);
use SDB::Install::Globals qw($gProductNameLSS);
use SDB::Install::LSS::Installer;

# Constructor
sub new {
    my $self = shift->SUPER::new ();
    return $self;
}

sub getAction {
    return "Remove";
}

sub getActionScope {
    return $gProductNameLSS;
}

sub getActionDone {
    return "removed";
}

sub getActionProgressive {
    return "Removing";
}

sub getProgramName {
    return 'lssremovehost';
}

sub InitCmdLineArgs {
    my ($self,$args) = @_;

    $self->{options} = {
        'keepUser' => undef,
        'keepUserGroup' =>undef,
        'instlog_dir' =>undef
    };
    GetOptions ('keep_user=s'   => \$self->{options}->{keepUser},
                'keep_user_group=s'   => \$self->{options}->{keepUserGroup},
                'instlog_dir=s' => \$self->{options}->{instlog_dir}
    );

    return 1;
}

sub init {
    my ($self) = @_;

    my $installer = SDB::Install::LSS::Installer->new();
    my $sid = $installer->getSid();

    $self->defineLog($self->{options}->{instlog_dir} // $self->getProgramName(), $self->getProgramName(), undef, $sid);

    my $lssInstance = $installer->getLssInstance();
    if(defined $lssInstance) {
        $lssInstance->setMsgLstContext($self->getMsgLstContext());
        return $lssInstance->remove($self->{options}->{keepUser},$self->{options}->{keepUserGroup},1);
    }

    return undef;
}

 sub main {
    my $app = new __PACKAGE__;
    $app->mainFunction(\@_);
}

sub shouldWarnIfCalledStandalone {
    return 1;
}

1;