package SDB::Install::ComponentVersion;

use strict;
use parent 'SDB::Install::Version';

sub new {
    my $self = shift()->SUPER::new(@_);
    $self->_buildVersion();
    return $self;
}

sub _buildVersion {
    my ($self) = @_;
    my @parts = @{$self->_getStringDetails()};
    my ($release, $revNumber, $revPatchLevel, $revChangelist) = ('', '', '00', '');

    if(scalar(@parts) == 5) { #revMajor.revMinor.revNumber.revPatchLevel.revChangelist
        ($release, $revNumber, $revPatchLevel, $revChangelist) = (sprintf('%s.%s', $parts[0], $parts[1]), $parts[2], $parts[3], $parts[4]);
    } elsif (scalar(@parts) == 4) { #revMajor.revNumber.revPatchLevel.revChangelist
        ($release, $revNumber, $revPatchLevel, $revChangelist) = ($parts[0], $parts[1], $parts[2], $parts[3]);
    } elsif (scalar(@parts) == 3) { #revMajor.revNumber.revChangelist
        ($release, $revNumber, $revChangelist) = ($parts[0], $parts[1], $parts[2]);
    }

    $self->{versionString} = join('.', ($release, $revNumber, $revPatchLevel, $revChangelist));
}

sub getVersion {
    my ($self) = @_;
    return $self->asString();
}

sub asString {
    my ($self) = @_;
    return $self->{versionString};
}

1;
