package SDB::Install::Configuration::Container::HdbCheckUpdateConfig;

use base SDB::Install::Configuration::Container::HdbContainerConfig;

use strict;

sub new {
    my $self = shift->SUPER::new (@_);

    my $section = 'HdbContainer';
    my $order   = 0;

    $self->{params} = {
        'Action'          => $self->getParamAction($order++, $section),
        'SrcManifest'     => $self->getParamSrcManifest($order++, $section),
        'TgtManifest'     => $self->getParamTgtManifest($order++, $section),
        'PluginManifests' => $self->getParamPluginManifests($order++, $section)
    };

    return $self;
}

sub getParamSrcManifest {
    my ( $self, $order, $section ) = @_;

    my %param = (
        'order'                       => $order,
        'opt'                         => 'src_manifest',
        'opt_arg'                     => '<path>',
        'type'                        => 'path',
        'section'                     => $section,
        'value'                       => undef,
        'str'                         => 'Source Manifest',
        'desc'                        => 'Server Manifest of Source Release',
        'mandatory'                   => 0,
        'init_with_default'           => 0
    );

    return \%param;
}

sub getParamTgtManifest {
    my ( $self, $order, $section ) = @_;

    my %param = (
        'order'                       => $order,
        'opt'                         => 'tgt_manifest',
        'opt_arg'                     => '<path>',
        'type'                        => 'path',
        'section'                     => $section,
        'value'                       => undef,
        'str'                         => 'Target Manifest',
        'desc'                        => 'Server Manifest of Target Release',
        'mandatory'                   => 1,
        'init_with_default'           => 0
    );

    return \%param;
}

sub getParamPluginManifests {
    my ( $self, $order, $section ) = @_;

    my %param = (
        'order'                       => $order,
        'opt'                         => 'plugin_manifests',
        'opt_arg'                     => '<manifestpath1>[,<manifestpath2>]...',
        'type'                        => 'csv',
        'section'                     => $section,
        'value'                       => undef,
        'str'                         => 'Plugin Manifests',
        'desc'                        => 'List of Plugin Manifests to Check',
        'mandatory'                   => 0,
        'init_with_default'           => 0
    );

    return \%param;
}

1;
