package SDB::Install::Configuration::GenericUninstallation;

use strict;
use SDB::Install::Configuration::Generic;
use SDB::Install::Configuration::Uninstallation;
use SDB::Install::SysVars;
use SDB::Install::DebugUtilities;

our @ISA = qw (SDB::Install::Configuration::Uninstallation SDB::Install::Configuration::Generic);


sub getParamFilter{
    return ['uninstallation'];
}

sub isUninstallation{
    return 1;
}

sub isInstallation{
    return 0;
}

sub isUpdate{
    return 0;
}

sub setInstallation {
    $_[0]->{installation} = $_[1];
}

sub getConfigXmlPath{
    my ($self) = @_;
    if (!defined $self->{installation}){
        return undef;
    }
    return $self->{installation}->getConfigXmlPath ();
}

sub getInstallation {
    return $_[0]->{installation};
}

sub getProductVersion {
    my ($self) = @_;
    if (!defined $self->{installation}){
        return undef;
    }
    return $self->{installation}->GetVersion();
}


1;
