package SDB::Install::Configuration::OptionIgnore;

use strict;

use base 'SDB::Install::Configuration::OptionWithArgs';

our $IGNORE_OPTION               = 'ignore';
our $IGNORE_GETOPT_SPEC          = "$IGNORE_OPTION=s";
our $IGNORE_ARGUMENT_SYNTAX      = "<check1>[,<check2>]...";
our $IGNORE_SYNTAX               = "--$IGNORE_OPTION=$IGNORE_ARGUMENT_SYNTAX";
our $IGNORE_ENV_VARIABLE         = 'HDB_INSTALLER_IGNORE';
our $IGNORE_DESCRIPTION_TEMPLATE = 'Ignores failing prerequisite checks (%s)';
our $IGNORE_LABEL_TEMPLATE = 'Ignore failing prerequisite checks (%s)';

sub getSyntax{
    return $IGNORE_SYNTAX;
}

sub getDescriptionTemplate{
    return $IGNORE_DESCRIPTION_TEMPLATE;
}

sub getLabelTemplate{
    return $IGNORE_LABEL_TEMPLATE;
}

sub getArgumentSyntax{
    return $IGNORE_ARGUMENT_SYNTAX;
}

sub getGetOptionSpec{
    return $IGNORE_GETOPT_SPEC;
}

sub getOptionName{
    return $IGNORE_OPTION;
}

sub getEnvValue{
    return $ENV{$IGNORE_ENV_VARIABLE};
}

sub getEnvironmentVariableName{
    return $IGNORE_ENV_VARIABLE;
}

1;
