package SDB::Install::Configuration::XMLPasswdParser;

use SDB::Install::XMLParser;
use SDB::Install::BaseLegacy;
use IO::Handle;
use strict;

our @ISA = qw (SDB::Install::XMLParser SDB::Install::BaseLegacy);

our $tagPasswords = 'Passwords';

sub parse{
    my ($self, $source) = @_;
    if (!defined $source) {
        $self->AddError("No source for XML content is given");
        return undef;
    }

    eval{
        $self->SUPER::parse ($source);
    };

    if ($@){
        $self->AddError ("Error parsing xml input: $@");
        return undef;
    }

    my $node = $self->getElementByTagName ($tagPasswords);

    if (!defined $node){
        $self->AddError ("No '$tagPasswords' tag found in xml");
        return undef;
    }
    return 1;
}

sub getPassword{
    my ($self, $wantedTag, $optionName) = @_;
    if (!defined $self->{root}){
        $self->AddError ("No parse tree");
        return undef;
    }

    my $node = $self->getElementByTagName ($tagPasswords);

    $node = $node->{child};

    while (defined $node){
        if ($node->{type} eq $wantedTag){
            return $node->{content};
        }
        $node = $node->{neighbor};
    }
    $self->AddError ("No password tag '$optionName' found");
    return undef;
}


1;
