package SDB::Install::DatabaseStudioSummary;

use strict;
use SDB::Install::Globals;

use SDB::Install::Utils::DatabaseStudio::DatabaseStudioKnownFeatures qw (GenerateFeatureDescriptionText);

sub buildSummaryTree {
    my ( $kit, $instconfig ) = @_;

    if (defined($instconfig->getFeatureManager()->{detector}) && $instconfig->getFeatureManager()->{detector}->isOldFeaturesSetInRepository()) {
        return undef;   
    }
    
    my $rootNodeRef  = buildRootNode($instconfig);    
    my $rootChildren = $rootNodeRef->{children};
    
    my $param;
    foreach my $param_id (@{$instconfig->getParamIds ()}){
        $param = $instconfig->{params}->{$param_id};                        
        if ($param->{skip}){
            next;
        }            
        if ($param->{type} eq 'passwd' || $param->{type} eq 'initial_passwd'){
            next;
        } 
        if (!(defined $param->{hidden} && $param->{hidden})) {        	
            my $paramNode = {
                "text"     => "$param->{str}: " . $instconfig->getLogValue ($param_id)
            };            
            push (@$rootChildren, $paramNode);   
        }
    }
    
    my $featuresNode = buildFeaturesNode($instconfig);
    if ($featuresNode) {
        push (@$rootChildren, $featuresNode);    	
    }        
    
    my $componentsNode = buildSoftwareComponentsNode($kit);
    push (@$rootChildren, $componentsNode);    
        
    return $rootNodeRef;
}

sub buildSoftwareComponentsNode {
    my ( $kit ) = @_;
    
    my @swComponentsChildren = ();
    my $swComponentsNodeRef  = {
        "text"     => sprintf ('Software Components (%.02f MB)',$kit->GetSelectedSize() / 1024.0 / 1024.0),
        "children" => \@swComponentsChildren
    };

    my $packages = $kit->GetPackages ();
    if (!defined $packages){
        # error
    } else {
        my $subnode;
        my $size;
        foreach my $package (sort {$a->{data}->{name} cmp $b->{data}->{name}} @$packages){          
            $size = sprintf "%.02f", ($package->GetSize / 1024.00 / 1024.00);
            my @children = _getComponentInformation($package->{data});            
            if (defined $package->{installed_package}){
                my @updateChildren = _getComponentInformation($package->{installed_package}->{data});               
                my $updatePackageNode = {
                    "text"     => 'Update package ',
                    "children" => \@updateChildren
                };            
                push (@children, $updatePackageNode);   
            }                                                            
            my $swComponentNode = {
                "text"     => $package->{data}->{name} .' ('. $size .' MB)',
                "children" => \@children
            };
            push( @swComponentsChildren, $swComponentNode );            
        }
    }

    return $swComponentsNodeRef;
}

sub buildFeaturesNode {
    my ( $instconfig ) = @_;

	my $featureManager = $instconfig->getFeatureManager();
    
    if (!defined($featureManager->{detector})){
        return undef;
    }
    
    if ( $featureManager->{detector}->isOldFeaturesSetInRepository() ) {
        return undef;	
    }	
    my @featuresChildren = ();
    
    my $selectedFeatures = $featureManager->getSelectedFeaturesIds();
    if (scalar @$selectedFeatures != 0) {
   		my @installChildren = ();    
    	foreach my $featureId (@$selectedFeatures) {
    		my $feature = $featureManager->{detector}->getRepositoryFeatureById($featureId);
        	my $installNode = {
                "text"     => GenerateFeatureDescriptionText($feature,1)
        	};     	
        	push (@installChildren, $installNode);
    	}
       	my $installFeaturesNode = {
        	"text"     => 'Install features',
           	"children" => \@installChildren
    	};    
    	push (@featuresChildren, $installFeaturesNode);
	}

    if ($instconfig->isUpdate()) {
        my $featuresForUpdate = $featureManager->getFeaturesForUpdate();
        if (scalar @$featuresForUpdate != 0) {
            my @updateChildren = ();            	
            foreach my $feature (@$featuresForUpdate) {
                my $updateNode = {
                        "text"     => GenerateFeatureDescriptionText($feature,1)
                };      
                push (@updateChildren, $updateNode);                
            }    
            my $updateFeaturesNode = {
                "text"     => 'Update features',
                "children" => \@updateChildren
            };    
            push (@featuresChildren, $updateFeaturesNode);                       
        }                           	
    }
    
    if (scalar @featuresChildren != 0) {
    	 my $featuresNodeRef  = {
        	"text"     => "Studio features",
        	"children" => \@featuresChildren
    	};
	    return $featuresNodeRef;
    }
    my $featuresNodeRef  = {
        	"text"     => "Studio features : none to install or update",
        	"children" => []
    	};
	return $featuresNodeRef;
}

sub _getComponentInformation {
    my ($data) = @_;        
    my @children = ();
    unless ($data) { return @children; }
    foreach my $key (keys %$data){
        if (($key eq 'git_hash') || ($key eq 'buildstring')) {
            push (@children, {"text" => "$key: ".$data->{$key}})                        
        }
    }       
    return @children;
}

sub buildRootNode{
	my ( $instconfig ) = @_;
	
	my @rootChildren = ();
    my $action = $instconfig->{action};
    my $rootNodeRef  = {
        "text"     => "$action $gProductNameStudio",
        "children" => \@rootChildren
    };
    
    return $rootNodeRef;  
}

return 1;
