#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Installation dialog - extract files and do register calls
#

package SDB::Install::Gui::Dialogs::CreateInstance;

use Wx qw (
	wxEXPAND
	wxTOP
	wxALL
	wxLEFT
	wxVERTICAL
	wxALIGN_LEFT
);

use base SAPDB::Install::Wizard::Dialog::Base;
use SAPDB::Install::Window::ExecPlan;
use SDB::Install::Gui::Design;
use SDB::Install::Globals qw ($gProductName);
use strict;

sub new{
	my($self ) = shift->SUPER::new(@_);

	$self->{id} = 'createInstance';
	$self->{name} = 'Create System';
	
	my $text = "Creating System";
	$self->{'caption'} = Wx::StaticText->new($self,-1,$text,[0,0],[-1,-1]);
	$self->{'caption'}->SetFont (SDBFONT_DialogTitle) if (!Wx::wxGTK1());
	
    my $top_sizer = Wx::BoxSizer->new(wxVERTICAL);
    $self->{'plan'} = SAPDB::Install::Window::ExecPlan->new($self,-1);
    $top_sizer->Add($self->{'caption'},0,wxALIGN_LEFT | wxLEFT | wxTOP , 20);
    $top_sizer->Add($self->{'plan'},1,wxALL | wxEXPAND, 20);
    $self->SetSizer($top_sizer);
    $self->SetAutoLayout(1);
    $self->Layout;
    return $self;
}

sub DirectNavigationAllowed ($) {0}

sub init{
	my ($self,$config) = @_;
	my $app = Wx::wxTheApp();
	
	$self->{'caption'}->SetLabel (sprintf ('Creating system %s',
		$app->{sapSystem}->{_sid}));
	return {'auto_next' => 1};
}


sub Process{
	my ($self,$config) = @_;
	
	my $app = Wx::wxTheApp();
	my $instconfig = $app->{instconfig};
	
	$app->{sapSystem}->setCallback (\&Wx::Yield);
	$app->{sapSystem}->setMsgLstContext ([$app->getMsgLst()]);
	$app->{sapSystem}->getMsgLst()->setProgressHandler ($self);
	if (!defined $app->{sapSystem}->createInstance ($instconfig, $app->GetSysInfo())){
		$app->ShowErrorMsg ('Cannot create system', $app->{sapSystem}->getErrMsgLst());
		$app->{sapSystem}->getMsgLst()->setProgressHandler ();
		return  {'errstate' => 1};			
	}
	$app->{sapSystem}->getMsgLst()->setProgressHandler ();
	return {};
}

sub CallbackRefresh;
*CallbackRefresh = \&Wx::Yield;


sub Destroy{
	my ($self) = @_;
    
    #
    #   Destroy Sizer
    #
    
	if(defined $self->GetSizer){
		$self->GetSizer->Clear (1);
	}
    
    #
    #   Destroy elements
    #
    
    foreach my $element (  'plan',
						'caption'
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
	$self->SUPER::Destroy;
}




sub InitProgress($$$$){
	my ($self,$steps,$value,$names) = @_;
	my @steps;
	foreach my $name (@$names){
		push @steps, {'Label' => $name, 'State' => 'PENDING'};
	}
	$self->{'plan'}->init(\@steps);
	$self->Layout ();
	Wx::Yield ();	
}


sub IncValue ($$){
	my ($self,$value) = @_;
	Wx::Yield ();	
}

sub IncRange ($$){
	my ($self,$value) = @_;
	Wx::Yield ();	
}


sub SetProgress ($$) {
	my ($self,$msg) = @_;
	Wx::Yield ();	
}


sub StepFinished{
    my ($self,$error) = @_;
    
    if ($error){
    	$self->{'plan'}->Next('FINISHED_ERROR');
    }
	else{
		$self->{'plan'}->Next ('FINISHED_SUCCESS');
    }
} 

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}



1;
