#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: SQL user options 

package SDB::Install::Gui::Dialogs::SQLUser;

use Wx qw (
    wxCENTRE
    wxVERTICAL
    wxDefaultSize 
    wxSWISS
    wxNORMAL
    wxBOLD
    wxHORIZONTAL
    wxEXPAND
	wxALL
    wxLEFT
    wxALIGN_CENTER_VERTICAL
    wxALIGN_CENTER_HORIZONTAL 
	wxALIGN_RIGHT
    wxTE_MULTILINE
    wxOK
    wxTOP
    wxBOTTOM
    wxCENTRE
    wxICON_EXCLAMATION
    wxID_OK
    wxDD_NEW_DIR_BUTTON
    wxBITMAP_TYPE_PNG
    wxALIGN_LEFT
    wxTE_PASSWORD
    wxSP_ARROW_KEYS
    wxCB_READONLY
    );

use Wx::Event qw( EVT_BUTTON EVT_CHECKBOX EVT_TEXT  );
                    
use SAPDB::Install::Wizard::Dialog::Base;
use SAPDB::Install::Control::PathCtrl;
use SDB::Install::Gui::Design;
use SDB::Install::Globals qw ($gProductName);
use SDB::Install::Gui::Control::Label;
use SAPDB::Install::Window::DBUserSimple;
use SDB::Install::SysVars qw ($isWin);
use strict;

our @ISA = qw (SAPDB::Install::Wizard::Dialog::Base);

our $paramId = 'SQLSysPasswd';

#our @user_params = $isWin ? ('Domain') : ('UID','GID','Shell', 'HomeDir');

sub new{
	my($self ) = shift->SUPER::new(@_);

    my $instconfig = Wx::wxTheApp->{instconfig};
    $instconfig->setBatchValueOfRequiredParams('DbMode');
    my $dbmode = $instconfig->getValue('DbMode');
    my $userString = "Database User";
    if ($instconfig->getValue('DbMode') =~ /multiple_containers|multidb/) {
        $userString =~ s/(?<!System\s)Database/System Database/g;
    }

    $self->{id} = 'SQLUserProperties';
    $self->{label_text} = "Specify Password of $userString 'SYSTEM'";
    $self->{name} = "Define $userString";

    return $self;
}

sub init {
	my ($self,$config) = @_;

	my $is_gtk1 =  Wx::wxGTK1();

	#
	#   Get default values
	#

	my $app = Wx::wxTheApp;

	my ($instconfig, $kit) = (
		$app->{instconfig},  # systeminstallation
		$app->{kit},    #packages
		);
	#
	# set parameters by cfg file and cmdln args 
	#
	
	my $msg = $app->getMsgLst ()->addMessage ("Checking configuration of Database user (dialog $self->{name})");
	$msg->setEndTag ('Configuration Check');
	$instconfig->setMsgLstContext([$msg->getSubMsgLst(),undef]);
	if (!defined $instconfig->setBatchValueOfRequiredParams ($paramId)){
		$app->ShowErrorMsg ('Initialize configuration failed', $instconfig->getErrMsgLst ());
		return undef;
	}
	
	if ($instconfig->{params}->{$paramId}->{skip}){
		# user already exists
		return {'auto_next' => 1};
	}
	my $password = $instconfig->getValue ($paramId);
	if($self->{batch_mode}){
		if (!$password){
			$app->setErrorMessage ("running in batch mode: $paramId unknown");
			$app->PrintUsage ();
			return undef;
		}
	}

	#
	#   Create Dialog
	#

	my $sizer = Wx::BoxSizer->new(wxVERTICAL);
	#my $left_sizer = Wx::BoxSizer->new(wxVERTICAL);
	
	#Titel
	$sizer->AddSpacer (16);
	$self->{'titel_big'} = Wx::StaticText->new($self, -1, $self->{label_text});
	$self->{'titel_big'}->SetFont( SDBFONT_DialogTitle ) if (!$is_gtk1);
	$sizer->Add($self->{'titel_big'},0, wxLEFT , 16 );
	$sizer->AddSpacer (16);
	$self->{'grid_sizer'} = Wx::FlexGridSizer->new(6, 2, 5, 15);
	
	$self->{user_window} = new SAPDB::Install::Window::DBUserSimple ($self,-1);
	$self->{user_window}->SetValue ({'Name' => 'SYSTEM',
		(defined $password ? ('Password' , $password, 'ConfirmPassword', $password) : ())});
	$self->{user_window}->{ctrl_user}->Enable (0);

	$sizer->Add($self->{user_window},0, wxLEFT , 16 );
	
	$self->SetSizerAndFit($sizer);
	$self->SetAutoLayout(1);
	$self->Layout();
	
	$self->Show(1);
	
	if ($instconfig->ErrorState){
		$self->GetWizard ()->LayoutDlg ();
		Wx::MessageBox($instconfig->GetErrorString (), "Configuration Error",
			 wxOK | wxCENTRE | wxICON_EXCLAMATION, $self );
	}

	return {}; 
}

sub Process{
	my ($self,$config) = @_;

    #
    #   check and set values
    #
    my $app = Wx::wxTheApp;
    my ($instconfig) = (
           $app->{instconfig},  # systeminstallation
        );
    my $param = $instconfig->{params}->{$paramId};
	if ($param->{skip}){
		# user already exists
		return {'auto_next' => 1};
	}


	$instconfig->resetError ();

	my ($value, $ctrl);
	my $dynctrl = $self->{dynctrl};

	my $msglst = $instconfig->getMsgLst ();

	my $user_values = $self->{user_window}->GetValue ();

	if (!$user_values->{Password}){
		Wx::wxTheApp ()->ShowErrorMsg ("Database User Password is empty");
		$self->{user_window}->{ctrl_passwd}->SetFocus();
		return undef;
	}

	if ($user_values->{Password} ne $user_values->{ConfirmPassword}){
		Wx::wxTheApp ()->ShowErrorMsg ("Password confirmation doesn't match");
		$self->{user_window}->SetFocus();
		return undef;
	}

	if (!$instconfig->setValue($paramId, $user_values->{Password})){
		Wx::wxTheApp ()->ShowErrorMsg ("Invalid Password",$instconfig->getErrMsgLst ());
		$self->{user_window}->SetFocus();
		return undef;
	}
	my $logvalue = $instconfig->getLogValue ($paramId, $user_values->{Password});
	$msglst->addMessage( $self->_getIsSetByUserMessagePattern($param, $paramId, $logvalue) );
	return {};
}


sub Back{
	$_[0]->Reset();
}	

sub Reset{
	my ($self) = @_;
    
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    #
    #   Destroy elements
    #
	delete $self->{title_big};
	delete $self->{dynctrl};
	delete $self->{user_window};
	$self->SUPER::Reset();
}

	

sub Destroy{
	my ($self) = @_;
	$self->Reset();
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}

1;
