package SDB::Install::Gui::Dialogs::SelectStudioInstallation;

use Wx qw(wxVERTICAL wxHORIZONTAL wxEXPAND wxALL wxALIGN_TOP wxTOP wxBOTTOM wxLEFT wxRIGHT wxALIGN_LEFT wxOK wxCENTRE wxGA_HORIZONTAL);
use Wx::Event qw (EVT_CHECKBOX);
use SDB::Install::Gui::Design;
use SDB::Install::ProgressHandler;

use strict;

use base 'SDB::Install::Gui::Dialogs::SelectInstallation', ;

sub addAdditionalUICtrlsLeft {
	my($self, $parentDlgLeftSizer) = @_;
	my $is_gtk1 = Wx::wxGTK1 ();
	my $instconfig = Wx::wxTheApp->{'instconfig'};
	my $startStudioAfterInstallParam = $instconfig->{params}->{'StartStudioAfterInstallation'};

	$self->{'startStudio_ctrl'} = new Wx::CheckBox ($self, -1, $startStudioAfterInstallParam->{'str'}, [-1,-1], [-1,-1]);
	$self->{'startStudio_ctrl'}->SetFont (SDBFONT_NormalText) if (!$is_gtk1);
	$parentDlgLeftSizer->Add($self->{'startStudio_ctrl'}, 0, wxLEFT | wxRIGHT, 20);
	
}

sub addAdditionalUICtrlsBottom {
	my($self, $sizer) = @_;
	#$parentDlgLeftSizer->AddSpacer (12);
	
	$self->{'progresstext'} = new Wx::StaticText($self,-1,' ',[0,0],[-1,-1]);;
    $self->{'progresstext'}->SetFont( SDBFONT_NormalText ) if (!Wx::wxGTK1());
	
	
	$sizer->Add($self->{'progresstext'},0,wxLEFT | wxRIGHT | wxTOP | wxBOTTOM ,20);
	
}

sub init{
	my ($self) = @_;
	my $rc = $self->SUPER::init(@_);
	my $instconfig = Wx::wxTheApp->{'instconfig'};
	my $startStudioAfterInstallParam = $instconfig->{params}->{'StartStudioAfterInstallation'};
	my $willStartStudioAfterInstall = (defined $startStudioAfterInstallParam->{value} ? $startStudioAfterInstallParam->{value} : $instconfig->getDefault('StartStudioAfterInstallation'));

	$self->{'startStudio_ctrl'}->SetValue($willStartStudioAfterInstall);

	return $rc;
}

sub Process{
	my ($self) = @_;
	my $instconfig = Wx::wxTheApp()->{instconfig};
	
	$instconfig->setProgressHandler($self);
	
	my $rc = $self->SUPER::Process(@_);
	$instconfig->setBatchValueOfRequiredParams ('SelectedFeatures');
    
	my $willStartStudioAfterInstall = $self->{'startStudio_ctrl'}->IsChecked();

	$instconfig->setValue('StartStudioAfterInstallation', $willStartStudioAfterInstall ? 1 : 0);

	return $rc;
}

sub InitProgress {
	my $self = shift;
	$self->{progresstext}->SetLabel('...');
	return 1;
}

sub StepFinished {
	my $self = shift;
	$self->{progresstext}->SetLabel(' ');
	return 1;
}

sub SetProgress{
	my ($self,$text) = @_;
	$self->{progresstext}->SetLabel($text);
	return 1;	
}

1;
