#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: 

package SDB::Install::Gui::Dialogs::UninstallSummary;

use Wx::Event qw (
                  );

use Wx qw ( 
        wxALL
        wxVERTICAL
        wxEXPAND
        wxSWISS
        wxNORMAL
        wxBOLD
        wxLEFT
        wxRIGHT
        wxTOP
        wxBOTTOM
          );

use SDB::Install::Gui::Design;
use SAPDB::Install::Wizard::Dialog::Base;
use SDB::Install::PackageManagerCollection;
use SDB::Install::Globals qw ($gProductNameInstaller);

our @ISA = qw (SAPDB::Install::Wizard::Dialog::Base);

my $UNINSTALLLIST = "_UninstallList_";

sub new{
	my($self ) = shift->SUPER::new(@_);
    
    $self->{id} = 'uninstall_summary';
    
    $self->{name} = 'Summary';
    
    my $sizer = Wx::BoxSizer->new(wxVERTICAL);

    #
    #   Tree
    #
    
    $self->{'tree_ctrl'} = Wx::TreeCtrl->new($self,-1,[0,0],[350,100]);
    $self->{'tree_ctrl'}->SetMinSize ([350,100]);     

    #
    #   Title
    #

    $self->{'titel_big'} = Wx::StaticText->new($self, -1, "Uninstallation Summary",);
    $self->{'titel_big'}->SetFont( SDBFONT_DialogTitle ) if (!Wx::wxGTK1());

    #
    #   Sizer
    #

    $sizer->Add($self->{'titel_big'},0,wxLEFT | wxTOP | wxBOTTOM,20);
    $sizer->Add($self->{'tree_ctrl'},1,wxEXPAND | wxLEFT | wxRIGHT | wxBOTTOM,20);

    $self->SetSizerAndFit($sizer);
    
	$self->SetAutoLayout(1);
	$self->Layout();
    
	return $self;
}


sub SetBusy{
    my ($self,$busy) = @_;
    if(not defined $busy or $busy){
        $self->Enable(0);
    }
    else{
        $self->Enable(1);       
    }
    return 1;
}

sub init(){
	my ($self, $config) = @_;
    $self->SetBusy(1);
    
    #
    #   Create summary content
    #
    
    $self->{'tree_ctrl'}->DeleteAllItems();
    
    $self->GetWizard->SetInstallMode (1,'&Uninstall');
    
    my $root = $self->{'tree_ctrl'}->AddRoot('not yet');
    $self->{'tree_ctrl'}->SetItemBold($root, 1);

    my $amount = 0;

    my $app = Wx::wxTheApp();
    my $installation;

    if (defined $app && $app->{installation}){
        $installation = $app->{installation};
        $self->{'tree_ctrl'}->SetItemText($self->{'tree_ctrl'}->GetRootItem(), 'Uninstallation of ' . $installation->asString);
        my $packages = $installation->GetPackages();
        if (!$installation->ErrorState){
            $amount += $installation->GetSelectedSize();
            $self->AppendPackagesStuff ( $root, $packages, 'Software Components', sprintf ('%.02f',$installation->GetSelectedSize() / 1024.0 / 1024.0) );
        }
    }
    elsif (defined $config->{packageManagerCollection}) {
        #
        #   Add Global Installation
        #
    
        #my $gconfig = $config->{packageManagerCollection}->getGlobalPackageManager();
        #if (defined @{$gconfig}[0]) { # global instalation is defined
        #    my $globalinstallation = @{$gconfig}[0];
        #    my $packages = $globalinstallation->GetPackages();
        #    if (!$globalinstallation->ErrorState){
        #        $amount =+ $globalinstallation->GetSelectedSize();
        #        $self->AppendPackagesStuff ( $root, $packages, "Global Installation", sprintf ('%.02f',$globalinstallation->GetSelectedSize() / 1024.0 / 1024.0) );
        #    }
        #}
        
        #
        #   Add MaxDB Installations 
        #
    
        for($config->{packageManagerCollection}->setIteratorToBegin(); $config->{packageManagerCollection}->iteratorHasMoreItems(); ) {
            my ($installation) = @{$config->{packageManagerCollection}->nextIteratorItem()};
            #if ($installation->isa (SDB::Install::Installation::GlobalInstallation)) { next; }
            my $packages = $installation->GetPackages();
            if (!$installation->ErrorState){
                $amount += $installation->GetSelectedSize();
                $self->AppendPackagesStuff ( $root, $packages, "Software Name: ".(defined $installation->GetName())?($installation->GetName()):('<NONE>'), sprintf ('%.02f',$installation->GetSelectedSize() / 1024.0 / 1024.0) );
            }
        }
        # set total MB
        $self->{'tree_ctrl'}->SetItemText($self->{'tree_ctrl'}->GetRootItem(), "SAP NewDB Uninstallation (total ".sprintf ('%.02f',$amount / 1024.0 / 1024.0)." MB)");
    }
    
    
	return {}; 
}


sub AppendPackagesStuff {
    my ($self, $parentNode, $packages, $stringPrefix, $amount) = @_;
    my $countComps = 0;
    
    my $item = $self->{'tree_ctrl'}->AppendItem($parentNode,"");
    $self->{'tree_ctrl'}->Expand($parentNode);
    
    #add components
    if (defined $packages){
        $countComps = scalar @$packages;
        foreach my $package (@$packages){
            my $name = $package->GetName()." (".sprintf ('%.02f',$package->GetSize() / 1024.0 / 1024.0)." MB)";
            $self->{'tree_ctrl'}->AppendItem ($item, $name);
        }
    } 
 
    $self->{'tree_ctrl'}->SetItemBold($item, 1);
    $self->{'tree_ctrl'}->SetItemText($item, $stringPrefix." ($countComps Packages; $amount MB)");
    1;
}


sub Process{
	my ($self,$config) = @_;

    #
    #   other stuff
    #
    
    my %rv;         
	return \%rv;
}


sub Back{
    my ($self,$config) = @_;
    $self->{'tree_ctrl'}->DeleteAllItems();
    $self->GetWizard->SetInstallMode (0);
    return 1;
}


sub Destroy{
	my ($self) = @_;
	
    #
    #   Destroy Sizer
    #
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    #
    #   Destroy elements
    #
    foreach $element (  
                        'tree_ctrl',
                        'titel_big',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
    
	$self->SUPER::Destroy;
}

sub DESTROY{
	my ($self) = @_;
	print ">>>>> destroying $self\n"
		if $SAPDB::Install::DEBUG::DESTRUCT;
}


1;
