package SDB::Install::Gui::Window::Dialog::MessageDialog;

use strict;

use Wx qw (
    wxVSCROLL
    wxALL
    wxVERTICAL
    wxHORIZONTAL
    wxID_OK
    wxID_YES
    wxID_NO
    wxID_CANCEL
    wxOK
    wxCANCEL
    wxYES
    wxNO
    wxYES_NO
    wxNO_DEFAULT
    wxICON_EXCLAMATION
    wxICON_HAND
    wxICON_ERROR
    wxICON_QUESTION
    wxICON_INFORMATION
    wxALIGN_RIGHT
    wxTE_MULTILINE
    wxTE_READONLY
    wxBORDER_NONE
    wxTE_NO_VSCROLL
    wxSYS_SCREEN_Y
    wxSYS_SCREEN_X
    wxSYS_DEFAULT_GUI_FONT
    wxRIGHT
    wxTOP
    wxBOTTOM
    wxEXPAND);

use Wx::Event qw (EVT_BUTTON);

our @ISA = qw (Wx::Dialog);

use SDB::Install::SysVars qw($isWin $isApple);


#-------------------------------------------------------------------------------
# Wx::MessageDialog clone
#
#   extended functionality:
#      - automatic vertical scrollbars
#      - message text can be marked and copied
#      - font can be changed (additional $font parameter)
#

sub new{
    my ($class, $parent, $message, $caption, $style, $pos, $font) = @_;
    my ($parentWidth, $parentHeight) = $parent->GetSizeWH();

    if (!defined $caption){
        $caption = 'Message box';
    }
    if (!defined $style){
        $style = wxOK | wxCANCEL;
    }
    if (!defined $pos){
        $pos = [-1,-1];
    }
    if (!defined $font){
        $font = Wx::SystemSettings::GetFont (wxSYS_DEFAULT_GUI_FONT);
    }
    my $self  = $class->SUPER::new($parent,-1, $caption, $pos);
    my $topSizer = new Wx::BoxSizer (wxVERTICAL);

    my $firstRowSizer = new Wx::BoxSizer (wxHORIZONTAL);
    my $iconHeight = 0;
    if (!$isApple){
        $iconHeight = $self->_createIcon ($style,$firstRowSizer);
    }
    my $screenHeight = Wx::SystemSettings::GetMetric(wxSYS_SCREEN_Y);
    my $colour = $self->GetBackgroundColour ();
    $self->_createTextCtrl ($message, $font, $firstRowSizer, $colour, $parentWidth, $screenHeight, $iconHeight);
    my $buttonSizer = new Wx::BoxSizer (wxHORIZONTAL);
    $self->_createButtons ($style, $buttonSizer);
    $topSizer->Add ($firstRowSizer, 1, wxALL | wxEXPAND, 10);
    $topSizer->Add ($buttonSizer, 0, wxALL | wxALIGN_RIGHT, 10);
    $self->SetSizer($topSizer);
    $self->Layout();
    if ($isWin){
        $self->_centerOnScreen ($screenHeight);
    }
    else{
        # workaround gtk themes bug
        $self->SetBackgroundColour ($colour);
    }
    return $self;
}

sub _centerOnScreen{
    my ($self, $screenHeight) = @_;
    my ($w,$h) = $self->GetSizeWH ();
    my $screenWidth = Wx::SystemSettings::GetMetric(wxSYS_SCREEN_X);
        my $posX = $screenWidth - $w;
        if ($posX < 0){
            $posX = 0;
        }
        else{
            $posX = int ($posX/2);
        }
        my $posY = $screenHeight - $h;
        if ($posY < 0){
            $posY = 0;
        }
        else{
            $posY = int ($posY/2);
        }
        $self->Move($posX,$posY);
}

sub _createIcon{
    my ($self, $style, $sizer) = @_;
    my $icon;
    if ($style & wxICON_EXCLAMATION){
        $icon = Wx::App::GetStdIcon (undef, wxICON_EXCLAMATION);
    }
    elsif ($style & wxICON_HAND || $style & wxICON_ERROR){
        $icon = Wx::App::GetStdIcon (undef, wxICON_ERROR);
    }
    elsif ($style & wxICON_QUESTION){
        $icon = Wx::App::GetStdIcon (undef, wxICON_QUESTION);
    }
    elsif ($style & wxICON_INFORMATION){
        $icon = Wx::App::GetStdIcon (undef, wxICON_INFORMATION)
    }
    if (!defined $icon){
        return 0;
    }
    my $staticBitmap = new Wx::StaticBitmap ($self, -1,new Wx::Bitmap ($icon));
    $sizer->Add ($staticBitmap, 0, wxRIGHT, 10);
    return $icon->GetHeight ();
}

sub _createTextCtrl{
    my ($self, $message, $font, $sizer, $colour, $parentWidth, $screenHeight, $iconHeight) =  @_;

    my $txtctrl = new Wx::TextCtrl ($self,-1, '',[-1,-1],[-1,-1],
        wxTE_MULTILINE|wxBORDER_NONE|wxTE_READONLY|wxVSCROLL);

    $txtctrl->SetFont ($font);
    $txtctrl->SetBackgroundColour ($colour);
    $txtctrl->SetValue ($message);
    my $offsetY = 0;
    if ($iconHeight){
        my $mdc = new Wx::MemoryDC ();
        $mdc->SelectObject (new Wx::Bitmap (1,1));
        my ($w,$h) = $mdc->GetTextExtent ('X', $font);
        $offsetY = int (($iconHeight - $h) / 2);
    }
    $sizer->Add($txtctrl, 1, wxEXPAND | wxTOP, $offsetY);
}

our $yesNoOrder = [wxYES, wxNO];
our $okCancelOrder = [wxOK, wxCANCEL];

our $styleFlagToWindowIdHashMap = {
    wxYES() => wxID_YES,
    wxNO() => wxID_NO,
    wxCANCEL() => wxID_CANCEL,
    wxOK() => wxID_OK
};

sub _createButtons{
    my ($self, $style, $buttonSizer) = @_;
    my $button;
    my $windowId;
    my $default;
    if ($style & wxYES_NO){
        # Yes and No buttons
        my $first = 1;
        $default = ((wxNO_DEFAULT) & $style) ? wxNO : wxYES;
        foreach my $flag (@$yesNoOrder){
            $windowId = $styleFlagToWindowIdHashMap->{$flag};
            $button = new Wx::Button ($self, $windowId);
            if ($default == $flag){
                $button->SetFocus ();
                $button->SetDefault ();
            }
            $buttonSizer->Add ($button, 0);
            if ($first){
                $buttonSizer->AddSpacer (10);
                $first = 0;
            }
            EVT_BUTTON ($self, $windowId, sub {$self->EndModal ($flag)});
        }
    }
    else{
        # OK and Cancel buttons
        my $one_added = 0;
        $default = ((wxOK) & $style) ? wxOK : wxCANCEL;
        foreach my $flag (@$okCancelOrder){
            if (!($flag & $style)){
                next;
            }
            $windowId = $styleFlagToWindowIdHashMap->{$flag};
            $button = new Wx::Button ($self, $windowId);
            if ($default == $flag){
                $button->SetFocus ();
                $button->SetDefault ();
            }
            if ($one_added){
                $buttonSizer->AddSpacer (10);
            }
            $buttonSizer->Add ($button, 0); 
            $one_added = 1;
            EVT_BUTTON ($self, $windowId, sub {$self->EndModal ($flag)});
        }
    }
}

1;