#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Build UI structure for the wizard
#

package SDB::Install::Gui::Window::Wizard;
use strict;

use Wx qw(
        wxTAB_TRAVERSAL
        wxEXPAND
        wxALIGN_CENTER_VERTICAL
        wxDefaultSize
        wxOK
	    wxDefaultPosition
        wxHORIZONTAL
	    wxVERTICAL
        wxALIGN_BOTTOM
        wxCENTRE
        wxALIGN_RIGHT
        wxCURSOR_ARROWWAIT
        wxICON_ERROR
	    wxLEFT
        wxRIGHT
        wxEVT_COMMAND_BUTTON_CLICKED
	    wxID_CANCEL
        wxID_FORWARD
        wxID_BACKWARD
        wxID_EXIT
        wxSIMPLE_BORDER
        wxGROW 
        );
use Wx::Event qw(EVT_BUTTON EVT_TOGGLEBUTTON );

use SDB::Install::Gui::Event qw (EVT_SDB_SELECT_STEP EVT_SDB_SELECT_SUBSTEP EVT_SDB_UNTERMINATE_CLICK);
use SDB::Install::Gui::Window::Floorplan qw (FLOORPLAN_STATUS_ACTIVE);
use SDB::Install::Gui::Control::Button;
use SDB::Install::SysVars qw ($isApple);

our @ISA = qw(Wx::Panel);

my $startHeight = 327; # Wizard start height


sub new{
	my($self ) = shift->SUPER::new(@_);
    $self->SetWindowStyleFlag($self->GetWindowStyleFlag | wxTAB_TRAVERSAL );
    
        
	#
    #   Sizer
    #
    
    my $top_sizer = Wx::BoxSizer->new(wxVERTICAL);
	my $dlg_sizer = Wx::BoxSizer->new(wxVERTICAL);
    my $button_sizer = Wx::BoxSizer->new(wxHORIZONTAL);
    $self->{'btn_sizer'} = $button_sizer;
    my $line_sizer = Wx::BoxSizer->new(wxHORIZONTAL);
    $self->{'page_sizer'} = Wx::BoxSizer->new(wxVERTICAL);
    
    
    #
    # Floorplan
    #
    
    $self->{floorplan} = new SDB::Install::Gui::Window::Floorplan($self,-1);
    $top_sizer->Add($self->{floorplan},0,wxEXPAND);    
    
    #
    #   Buttons
    #
    

	if ($^O !~ /mswin/i){
		$self->SetBackgroundColour (new Wx::Colour (204,204,204));
	}
	 
	$self->{'nbutton'} = SDB::Install::Gui::Control::Button->new($self,wxID_FORWARD,'&Next >');
    $self->{'pbutton'} = SDB::Install::Gui::Control::Button->new($self,wxID_BACKWARD,'< &Previous');
    $self->{'cbutton'} = SDB::Install::Gui::Control::Button->new($self,wxID_CANCEL,' &Cancel ');

	$self->{'pbutton'}->Enable(0);
	



    $button_sizer->Add($self->{'pbutton'},0,wxALIGN_CENTER_VERTICAL);
	$button_sizer->AddSpacer (5);
    $button_sizer->Add($self->{'nbutton'},0,wxALIGN_CENTER_VERTICAL);
	$button_sizer->AddSpacer (5);
    $button_sizer->Add($self->{'cbutton'},0,wxALIGN_CENTER_VERTICAL | wxRIGHT);
	$button_sizer->AddSpacer (5);
	

    $button_sizer->Layout();
    
    $self->{'nbutton_event'} = Wx::CommandEvent->new(wxEVT_COMMAND_BUTTON_CLICKED,$self->{'nbutton'}->GetId);
    $self->{'pbutton_event'} = Wx::CommandEvent->new(wxEVT_COMMAND_BUTTON_CLICKED,$self->{'pbutton'}->GetId);
    
    EVT_BUTTON($self,wxID_BACKWARD,\&OnPrev);
    EVT_BUTTON($self,wxID_FORWARD,\&OnNext);
    EVT_BUTTON($self,wxID_CANCEL,\&OnCancel);
    
    #
    #   Dialog Sizer
    #
    
    $self->{'button_sizer'} = $button_sizer;
    $dlg_sizer->Add($self->{'page_sizer'},1, wxEXPAND);
	$dlg_sizer->AddSpacer (5);
    $dlg_sizer->Add($button_sizer,0, wxALIGN_RIGHT);
	$dlg_sizer->AddSpacer (5);
    $top_sizer->Add($dlg_sizer,1,wxALIGN_BOTTOM | wxEXPAND);
    $self->SetSizer($top_sizer);
    $self->{'wizard_top_sizer'} = $top_sizer;
    
    #
    #   Dialog
    #
    
    $self->{'start_height'} = $startHeight;
    
	$self->SetAutoLayout(1);
	$self->Layout();
	$self->{'config'} = {};
    
    if (defined $self->{floorplan}) {
		EVT_SDB_SELECT_STEP ($self,$self->{floorplan}->GetId,\&OnFloorplanSelectStep);
		EVT_SDB_SELECT_SUBSTEP ($self,$self->{floorplan}->GetId,\&OnFloorplanSelectSubStep);
		EVT_SDB_UNTERMINATE_CLICK ($self,$self->{floorplan}->GetId,\&OnFloorplanUnterminateClick);
    }
    
    $self->{condensed_step} = 0;
      
	return $self;
}


sub setBanner{
    my ($self, $banner) = @_;
    my $sizer = $self->GetSizer ();
    if (defined $self->{banner}){
        $sizer->Detach ($self->{banner});
        $self->{banner}->Destroy ();
    }
    $self->{banner} = $banner;
    if (defined $banner){
        $sizer->Prepend ($self->{banner}, 0, wxEXPAND);
    }
    return 1;
}


#>---------------------------------Steps------------------------------------------<#

sub initDialog{
	my ($self) = @_;
	
	
	if ($self->{'current_dlg'}->{'initialized'}){
		return;
	}
	
	unless (exists $self->{'current_dlg'}->{'show_self_defined'}){
		$self->{'current_dlg'}->Show(1); # if you don't call this before LayoutDlg, the dialog looks bad while SetBusy is on.
                
    }
        
    # Subtitles never used in the SDB SAPBanner, but the old SAPDB Banner can do this.
	    #$self->GetParent->{'banner'}->setSubTitle($self->{'current_dlg'}->{'name'})
	    #	if defined $self->GetParent->{'banner'};
	$self->setBusy(1);
	my $rc;

    eval {$rc = $self->{'current_dlg'}->init($self->{'config'});};
    if ($@){
       return $self->handleException ($@);
    }

	return undef if($self->{'destroying'});
	$self->setBusy(0);
	if(defined $rc){
		if(defined $rc->{'errstate'} && $rc->{'errstate'} == 1){
			if(defined $rc->{'errmsg'}){
				my $msgbox = Wx::MessageDialog->new($self,$rc->{'errmsg'},
					"Fatal Error", wxICON_ERROR | wxCENTRE | wxOK);
					$msgbox->ShowModal();
				$msgbox->Destroy;
			}
			$self->{'error_state'} = 1;
			$self->{'config'}->{'error_state'} = 1;
			$self->gotoErrHandlerPage;
			return undef;
		}
		$self->SetConfig($rc);
		$self->{'current_dlg'}->{'initialized'} = 1;
		unless (exists $self->{'current_dlg'}->{'show_self_defined'}){
			$self->{'current_dlg'}->Show(1);
			$self->LayoutDlg; #<<<<<<<<<<< this statement is necessary, otherwise the layout of the second dialog is not centered...?!?!?
		}
		$self->{'current_dlg'}->{'initialized'} = 1;
		if($rc->{'auto_next'}){
				Wx::PostEvent($self,$self->{'nbutton_event'});
		}
        if (Wx::wxGTK && Wx::wxVERSION >= 3){
            # workaround to call RealizeTabOrder()
            # set m_dirtyTabOrder=true
            # see wxWidgets/src/gtk/window.cpp
            my $dummy = new Wx::Panel ($self, -1);
            $dummy->Destroy ();
        }
		return 1;
	}
	return undef;

}

sub AddDialog{
	my ($self,$dlg) = @_;
	
	if ($self->{chain_terminated}){
		return 0;
	}

	if (!defined $self->{plan_list}){
		$self->{plan_list} = [];
	}
	
	push @{$self->{plan_list}}, $dlg->GetID ();
		
	if( defined $self->{'lastadded'}){
		$dlg->SetPrevious ($self->{'lastadded'});
		$self->{'lastadded'}->SetNext ($dlg);
	}
	else{
		$self->{'current_dlg'} = $dlg;
	}
	
	$self->{'lastadded'} = $dlg;
	return 1;
}



sub AddCondensedStep{
	my ($self,$id, $name) = @_;
	
	if (!defined $self->{plan_list}){
		$self->{plan_list} = [];
	}
	
	if (!defined $self->{CondensedSteps}){
		$self->{CondensedSteps} = {};
	}
	
	$self->{CondensedSteps}->{$id} = $name;
	
	
	push @{$self->{plan_list}}, [$id];
	
	return 1;
}

sub ResetCondensedStep{
	my ($self,$id) = @_;
	
	my $index = $self->GetCondensedIndex ($id);
	
	if (!defined $index){
		return undef;
	}
	(undef, my @dlg_ids) = @{$self->{plan_list}->[$index]};
	
	foreach my $dlg_id (reverse @dlg_ids){
		$self->RemoveDialog ($dlg_id);
	}
	
	$self->{floorplan}->{plan}->[$index]->[2] = [];
	
	$self->{plan_list}->[$index] = [$self->{plan_list}->[$index]->[0]];
	
	return 1;
}



sub GetCondensedIndex ($$) {
	my ($self, $id) = @_;
	
	foreach my $i (0 .. scalar @{$self->{plan_list}} - 1){
		if (ref ($self->{plan_list}->[$i]) eq 'ARRAY'){
			if ($id eq $self->{plan_list}->[$i]->[0]){
				return $i;
			}
		}
	}
	return undef;
}


sub EnableCondensedStep{
	my ($self,$id,$enable) = @_;
	
	my $index = $self->GetCondensedIndex ($id);
	
	if (!defined $index){
		return undef;
	}
	
	if (defined $enable && !$enable){
		$enable = 0;
	}
	else{
		$enable = 1;
	}
	
	$self->{floorplan}->setEnable ($index,$enable);
		
}

sub InsertDialog{
	my ($self, $dlg, $id, $condensed_id) = @_;
	
	if (!defined $condensed_id){
		return undef;
	}
		
	my $relation_dlg = $self->{'current_dlg'}; 
	
	if(defined $id){
		$relation_dlg = $self->FindDialog($id);
		if (!defined $relation_dlg){
			my $msgbox = Wx::MessageDialog->new($self,"Cannot find Wizard dialog \"$id\"!\nInserting Dialog \"".$dlg->GetName."\" failed!\n",
						"Fatal Error", wxICON_ERROR | wxCENTRE | wxOK);
						$msgbox->ShowModal();
			return undef;
		}
	}
	elsif (!defined $relation_dlg){
		$self->{'current_dlg'} = $dlg;
	}
	else{
		my $first = $relation_dlg;
		while (defined $first->GetPrevious()){
			$first = $first->GetPrevious();
		}
		$self->{'current_dlg'} = $dlg;
		$first->SetPrevious ($dlg);
		$dlg->SetNext ($first);
		undef $relation_dlg;	
	}
	
	my $cond_index = $self->GetCondensedIndex ($condensed_id);
	
	if (defined $dlg->GetName){
	
		$dlg->SetStep($cond_index);
		
		
		my $sub_index = scalar @{$self->{floorplan}->{plan}->[$dlg->GetStep]->[2]};  
		$dlg->SetSubStep($sub_index);

		push @{$self->{floorplan}->{plan}->[$dlg->GetStep]->[2]}, [$dlg->GetName,0];

		if ($dlg->DirectNavigationAllowed ()){
			$self->{floorplan}->setEnableSub ($cond_index, $dlg->GetSubStep);
		}

	}
	
	push @{$self->{plan_list}->[$cond_index]}, $dlg->GetID();
	
	
	if (defined $relation_dlg){
	
		$dlg->SetPrevious ($relation_dlg);
	
		if (defined $relation_dlg->GetNext ()){
			$dlg->SetNext ($relation_dlg->GetNext ());
			$relation_dlg->GetNext ()->SetPrevious ($dlg);
		}
		$relation_dlg->SetNext ($dlg);
	}
	
	if (!$self->{chain_terminated}){
		$self->{lastadded} = $dlg;
	}
	return 1;
}


sub RemoveDialog{
	my ($self,$id) = @_;
	my $msgbox = $self->TryToRemoveDialog($id);

	if ( defined $msgbox ) {
		$msgbox->ShowModal();
		return undef;
	}
	
	return 1;
}

sub TryToRemoveDialog {
	my ($self,$id) = @_;
	my $relation_dlg = $self->{'current_dlg'}; 
	my $kill_current = 1;

	if ( $id =~ /\S/ ) {
		if ( $relation_dlg->GetID () ne $id ) {
			$relation_dlg = $self->FindDialog($id);
			if ( ! defined $relation_dlg ) {
				my $msgbox = Wx::MessageDialog->new($self,"Cannot find Wizard dialog \"$id\"!\nRemoving dialog failed!\n",
						"Fatal Error", wxICON_ERROR | wxCENTRE | wxOK);
				return $msgbox;
			}
			$kill_current = 0;
		}
	}

	if ( defined $relation_dlg->GetNext() ) {
		my $setPreviousTo;
		if(defined $relation_dlg->GetPrevious ()){
			$setPreviousTo = $relation_dlg->GetPrevious();
		}
		$relation_dlg->GetNext ()->SetPrevious($setPreviousTo);
	}
	
	if ( defined $relation_dlg->GetPrevious() ) {
		my $setNextTo;
		if(defined $relation_dlg->GetNext ()){
			$setNextTo = $relation_dlg->GetNext();
		}
		$relation_dlg->GetPrevious ()->SetNext( $setNextTo );
		$self->{'current_dlg'} = $self->{'current_dlg'}->GetPrevious() if $kill_current;	
	}else{
		$self->{'current_dlg'} = $self->{'current_dlg'}->GetNext() if $kill_current;
	}
	$relation_dlg->Destroy ();
	return undef;
}

sub FindDialog{
	my ($self,$id) = @_;
	
	my $dlg = $self->{'current_dlg'};
	
	return $dlg if($dlg->GetID eq $id);
	
	#search backward
	while(1){
		$dlg = $dlg->GetPrevious ();
		last if !defined $dlg;
		if($dlg->GetID() eq $id){
			return $dlg
		}
	}

	#search foreward
	$dlg = $self->{'current_dlg'};
	while(1){
		$dlg = $dlg->GetNext ();
		last unless defined $dlg;
		last if !defined $dlg;
		if($dlg->GetID() eq $id){
			return $dlg
		}
	}
	return undef;
}


sub SkipDialog{
	my ($self,$id,$skip) = @_;
	my $dlg = $self->FindDialog ($id);
	
	return undef if !defined $dlg;
	
	if(!defined $skip || $skip){
		$skip = 1;
	}
	else{
		$skip = 0;
	}
	
	$dlg->SetSkip ($skip);
	
	if (defined $dlg->GetSubStep){
		$self->{floorplan}->setEnableSub ($dlg->GetStep,$dlg->GetSubStep,!$skip);
	}
	else{
		$self->{floorplan}->setEnable ($dlg->GetStep,!$skip);
	}
	return 1;	
}

sub KillDialogs{
	my ($self) = @_;
	
	my $next_dlg = $self->{'current_dlg'};
	
	return 1 if !defined $next_dlg; 
	
    #
	#   find fist dlg
    #
    
	while(1){
		last if !defined $next_dlg->GetPrevious ();
		$next_dlg = $next_dlg->GetPrevious ();
	}

	#
	#   killing all dlgs
    #
    
    my $dlg;
    
	while(1){
		$dlg = $next_dlg;
		$next_dlg = $dlg->GetNext();
		$dlg->Destroy ();
		if (!defined $next_dlg){
			last;
		}
		
	}
	delete $self->{'current_dlg'};
	return 1;
}


sub KillPreviousDialogs{
	my ($self) = @_;
	
	my $dlg = $self->{'current_dlg'};
	
	my $tmp;
	while(1){
		$tmp = $dlg;			
		$dlg = $dlg->GetPrevious ();
		if (defined $dlg){
			$tmp->SetPrevious (undef);

			if (defined $dlg->GetSubStep){
				$self->{floorplan}->setEnableSub ($dlg->GetStep (),$dlg->GetSubStep (), 0);
			}
			else{
				$self->{floorplan}->setEnable ($dlg->GetStep (), 0);
			}

			$dlg->SetNext (undef);
			$dlg->Destroy();
		}
		else{
			last;
		}
	}
	return 1;
}

sub DisableNextDialog {
	my ($self) = @_;
	my $dlg = $self->{'current_dlg'}->GetNext();
	
	$self->{floorplan}->setEnable($dlg->GetStep(), 0);
}

#>---------------------------------Wizard Stuff------------------------------------------<#

sub SetConfig{
	my ($self,$config) = @_;
	unless(ref($config) eq 'HASH'){
		return undef;
	}
	foreach my $key (keys(%$config)){
		next if($key eq 'auto_next');
		$self->{'config'}->{$key} = $config->{$key};
	}
	return 1;
}

sub LayoutDlg{
	my ($self) = @_;
	my $dlg = $self->{'current_dlg'};
	if (exists $dlg->{'show_self_defined'} && !exists $dlg->{'already_shown'}){
		if (exists $self->{'hold_dlg'} && defined $self->{'hold_dlg'}){
			$self->{'page_sizer'}->Detach ($self->{'hold_dlg'});
                        $self->{'hold_dlg'}->Show(0);
			delete $self->{'hold_dlg'};
		}
		else{
			$self->{'page_sizer'}->Detach ($self->{'current_dlg'}->GetPrevious ());
            $self->{'current_dlg'}->GetPrevious ()->Show(0);
		}
	}

    if (!defined $self->{_added} || $self->{_added} != $dlg){
        $self->{'page_sizer'}->Add($dlg,1,wxEXPAND);
        $self->{_added} = $dlg;
    }

	if (exists $dlg->{'show_self_defined'} && !exists $dlg->{'already_shown'}){
                $dlg->Show(1);
		$dlg->{'already_shown'} = 1;
    }

	$self->{'page_sizer'}->Layout();

	if (defined $dlg->GetSubStep ()){
		$self->{floorplan}->selectSubStep ($dlg->GetStep (),$dlg->GetSubStep ());
	}
	else{
		$self->{floorplan}->selectStep ($dlg->GetStep ());
	}
}

sub init{
	my ($self) = @_;
	
	
	
	unless($self->{'current_dlg'}->GetPrevious ()){
		
		if (!$self->{chain_terminated}){
			my $dlg = $self->{'current_dlg'};
			my @plan;
			my $i = 0;
		
			#
			# init floorplan
			#
		
			while(1){
				if (ref ($self->{plan_list}->[$i]) eq 'ARRAY'){
					my $name = $self->{plan_list}->[$i]->[0];
			
					if (defined $self->{CondensedSteps}->{$name}){
						$name = $self->{CondensedSteps}->{$name};
					}
					push @plan, [$name,FLOORPLAN_STATUS_ACTIVE,[]];
				}
				else{
					push @plan, [$dlg->GetName,FLOORPLAN_STATUS_ACTIVE];
					$dlg->SetStep ($i);
					last unless defined $dlg->GetNext ();
					$dlg = $dlg->GetNext ();
				}
				$i++;
			}
			$self->{floorplan}->SetPlan (\@plan,1);
		}
		
		if(defined $self->{'current_dlg'} && !$self->{'current_dlg'}->{'show_self_defined'}){
			if ($self->{'current_dlg'}->GetSkip ()){
				Wx::PostEvent ($self, $self->{'nbutton_event'});
			}
			else{
				$self->{'current_dlg'}->Show(1);
				$self->initDialog;
			}
		}
	}
	$self->SetDefaultFocus;
}

#
# terminateChain ()
# Forbids AddDialog(), only InsertDialog() to condensed steps are possible.
# Floorplan control has fix plan afterwards.
#

sub terminateChain{
	my ($self) = @_;
	my $dlg = $self->{'current_dlg'};
	my @plan;
	my $i = 0;
		
	#
	# init floorplan
	#
		
	$dlg = $self->getFirstDialog($dlg);
		
	while(1){
		if (ref ($self->{plan_list}->[$i]) eq 'ARRAY'){
			my $name = $self->{plan_list}->[$i]->[0];
			if (defined $self->{CondensedSteps}->{$name}){
				$name = $self->{CondensedSteps}->{$name};
			}
			push @plan, [$name,FLOORPLAN_STATUS_ACTIVE,[]];
			$i++;
		}
		else{
			$dlg->SetStep ($i);
			
			if (defined $dlg->GetName ()){
				push @plan, [$dlg->GetName,FLOORPLAN_STATUS_ACTIVE];
				$i++;
			}
			last unless defined $dlg->GetNext ();
			$dlg = $dlg->GetNext ();
		}
		
	}
	$self->{chain_terminated} = 1;
	$self->{floorplan}->SetPlan (\@plan);
	delete $self->{'lastadded'};
}

sub getFirstDialog {
	my ($self, $dlg) = @_;
	
	while (1) {
		if(defined $dlg->GetPrevious()) {
			$dlg = $dlg->GetPrevious();
		} else {
			last;
		}
	}
	
	return $dlg;
}

sub getCurrentDialog {
	my ($self) = @_;
	return $self->{current_dlg};
}

#
# unterminateChain ()
# Reverse method to terminateChain()
# Allows to call AddDialog() afterwards and 
# modify dialog chain incl. floorplan control.
#

sub unterminateChain{
	my ($self) = @_;

	if (!$self->{chain_terminated}){
		return 1;
	}

	#
	# kill next dialogs
	#
	
	my $dlg = $self->{'current_dlg'}->GetNext ();
	
	my $index = $self->{'current_dlg'}->GetStep ();
	
	while (defined $dlg){
		$dlg->Destroy ();
		$dlg->SetPrevious (undef);
		$dlg = $dlg->GetNext ();
		
	}
	
	$self->{'current_dlg'}->SetNext (undef);
	
	
	#
	# reset structurts 'plan_list' and 'CondensedSteps'
	#
	
	
	my @new_list;
	
	foreach my $i (0 .. scalar (@{$self->{plan_list}}) - 1){
		
		if ($i <= $index){
			push @new_list, $self->{plan_list}->[$i];
			next;
		}
		if (ref ($self->{plan_list}->[$i]) eq 'ARRAY'){
				my ($key) = @{$self->{plan_list}->[$i]};
				if (exists $self->{CondensedSteps}->{$key}){
					delete $self->{CondensedSteps}->{$key};
				}	
		}
	}
	$self->{plan_list} = \@new_list;
		
	#
	# find first dlg
	#
	
	$dlg = $self->{'current_dlg'};
	
	$self->{'lastadded'} = $dlg;
	
	while (defined $dlg->GetPrevious()){
		$dlg = $dlg->GetPrevious();
	}	
	
	my @plan;
	my $i = 0;
		
	#
	# init floorplan
	#
		
	while(1){
		if (ref ($self->{plan_list}->[$i]) eq 'ARRAY'){
			
			#
			# condensed step
			#
			
			my $name = $self->{plan_list}->[$i]->[0];
			if (defined $self->{CondensedSteps}->{$name}){
				$name = $self->{CondensedSteps}->{$name};
			}
			push @plan, [$name,FLOORPLAN_STATUS_ACTIVE,[]];
		}
		else{
			
			#
			# regular step
			#
		
			push @plan, [$dlg->GetName,FLOORPLAN_STATUS_ACTIVE];
			$dlg->SetStep ($i);
			last unless defined $dlg->GetNext ();
			$dlg = $dlg->GetNext ();
		}
		$i++;
	}
	$self->{chain_terminated} = 0;
	$self->{floorplan}->SetPlan (\@plan,1);
}



sub setBusy{
	my($self,$enable) = @_;

	# enable/disable floorplan access
	$self->{floorplan}->Enable(!$enable);

	if($enable){
		if(defined $self->{'current_dlg'} && 
				   $self->{'current_dlg'}->can('SetBusy')){
			
			$self->{'current_dlg'}->SetBusy(1);
		
		}
		$self->{'nbutton'}->Enable(0);
		$self->{'pbutton'}->Enable(0);
		if ($^O =~ /mswin/i){
			$self->{'busy_cursor'} = 
				Wx::BusyCursor->new(Wx::Cursor->new(wxCURSOR_ARROWWAIT));
		}
		else{
			$self->{'busy_cursor'} = Wx::BusyCursor->new();
		}
	}
	else{
		if(defined $self->{'current_dlg'} and 
				   $self->{'current_dlg'}->can('SetBusy')){
			
			$self->{'current_dlg'}->SetBusy(0);
		
		}
		if(defined $self->{'current_dlg'}->GetNext () || !$self->{chain_terminated}){
			unless($self->{'nbutton_disabled'}){		
				$self->{'nbutton'}->Enable(1);
			}
		}
		if($self->{'current_dlg'}->CanBackward ()){
			$self->{'pbutton'}->Enable(1);
		}
		if (exists $self->{'busy_cursor'}){
			delete $self->{'busy_cursor'};
		}
	}
	
	return 1;	
}

#
# event handler
#

sub _handleFloorPlanSelectStepEvent{
    my ($self, $id, $evt) = @_;
    my $curDlg = $self->{current_dlg};
    my $dlg_id = $curDlg->GetId ();

    if (!defined $curDlg->GetName || $self->{last_dlg_id} == $dlg_id){
        undef $self->{last_dlg_id};
        # break recusion
        return;
    }
    $self->{last_dlg_id} = $dlg_id;

    my $new_id = $evt->GetInt ();
    if ($id > $new_id){
        Wx::PostEvent ($self, $self->{'pbutton_event'});
# Synchronization point is needed, because triggering a button event might result in a chain of events
# ProcessPendingEvents must be called only on non empty event queue
        Wx::wxTheApp()->ProcessPendingEvents();
    }
    elsif ($id < $new_id){
        Wx::PostEvent ($self, $self->{'nbutton_event'});
# Synchronization point is needed, because triggering a button event might result in a chain of events
# ProcessPendingEvents must be called only on non empty event queue
        Wx::wxTheApp()->ProcessPendingEvents();
    }
    else{
        undef $self->{last_dlg_id};
        return;
    }
    Wx::PostEvent ($self, $evt); #post $evt again => recusive call
}

sub OnFloorplanSelectStep{
    my ($self,$evt) = @_;
    my $id = $self->{current_dlg}->GetStep ();
    $self->_handleFloorPlanSelectStepEvent ($id,$evt);
}

sub OnFloorplanSelectSubStep{
    my ($self,$evt) = @_;
    my $id = $self->{current_dlg}->GetSubStep ();
    $self->_handleFloorPlanSelectStepEvent ($id,$evt);
}

sub OnFloorplanUnterminateClick{
	my ($self,$evt) = @_;
	Wx::PostEvent ($self, $self->{'nbutton_event'});
}


sub PostNextEvent{
    Wx::PostEvent ($_[0], $_[0]->{nbutton_event});
}


sub OnPrev{
	my ($self,$event) = @_;

	return undef if($self->{'destroying'});
	my $auto_back = 0;
	
	if (!$self->{'current_dlg'}->CanBackward ()){
		return 0;
	}
	
	
	if (defined $self->{'current_dlg'} && 
	    exists $self->{'current_dlg'}->{'show_self_defined'} && 
	    exists $self->{'current_dlg'}->{'already_shown'}){
		delete $self->{'current_dlg'}->{'already_shown'};
	}
	
	if (exists $self->{'hold_dlg'} && 
	    $self->{'hold_dlg'} == $self->{'current_dlg'}){
		delete $self->{'hold_dlg'};	
	}
	
	
	if(!$self->{'current_dlg'}->GetSkip () && $self->{'current_dlg'}->can ('Back')){
		my $rc = $self->{'current_dlg'}->Back($self->{'config'});
		return undef unless defined $rc;
		if(ref($rc) eq 'HASH' and $rc->{'auto_back'}){
			$auto_back = 1;
		}
	}
	
	if(!$self->{'current_dlg'}->GetSkip ()){
		$self->{'nbutton'}->Enable(1);
		$self->{'page_sizer'}->Detach ($self->{'current_dlg'});
		$self->{'current_dlg'}->Reset ();
		$self->{'current_dlg'}->Show(0);
	}
	
		
	$self->{'current_dlg'} = $self->{'current_dlg'}->GetPrevious ();
	
    unless($self->{'current_dlg'}->CanBackward ()){
		$self->{'pbutton'}->Enable(0);
		$self->SetDefaultFocus;
	}

	
	if($self->{'current_dlg'}->GetSkip ()){
		Wx::PostEvent ($self, $self->{pbutton_event});
		return 1;
	}
	
	if(defined $self->{'current_dlg'}){
		if($self->{'current_dlg'}->can('BackInit')){
			my $rc = $self->{'current_dlg'}->BackInit($self->{'config'});
			$auto_back = 1 if($rc->{'auto_back'});
		}
		$self->{'current_dlg'}->Enable(1);
		$self->{'current_dlg'}->Show(1);
		$self->LayoutDlg;
	}
		
	if($auto_back){
		Wx::PostEvent ($self, $self->{pbutton_event});
	}
	
	return 1;
}

sub handleException{
    my ($self, $exception) = @_;

    if ($exception =~ /__SIGINT__/){
        die ($exception);
    }

    my $msglst = new SDB::Install::MsgLst ();
    $msglst->addError ($exception, Wx::wxTheApp()->{stackBacktraceMsglst});
    Wx::wxTheApp()->ShowErrorMsg ('Runtime Error', $msglst);
    $self->{'error_state'} = 1;
    $self->{'config'}->{'error_state'} = 1;
    $self->gotoErrHandlerPage;
    return undef;
}

sub gotoErrHandlerPage{
	my ($self) = @_;
	while(1){
		if(defined $self->{'current_dlg'}->GetNext ()){
			$self->{'page_sizer'}->Detach ($self->{'current_dlg'});
			$self->{'current_dlg'}->Enable(0);
			#$self->{'current_dlg'}->Show(0);
			$self->{'current_dlg'} = $self->{'current_dlg'}->GetNext ();
		}
		else{
            # Subtitels never used in the SDB SAPBanner, but the old SAPDB Banner can do this.
			    #$self->GetParent->{'banner'}->setSubTitle($self->{'current_dlg'}->{'name'})
			    #	if defined $self->GetParent->{'banner'};
			$self->setBusy(1);
			my $rc = $self->{'current_dlg'}->init($self->{'config'});
			return undef if($self->{'destroying'});
			$self->setBusy(0);
			if(defined $rc){
				$self->SetConfig($rc);
				$self->{'current_dlg'}->Show(1);
				$self->LayoutDlg;
				if($rc->{'auto_next'}){
					Wx::PostEvent ($self, $self->{nbutton_event});
				}
			}
			last;
		}
	}
	return 1;
}


sub OnNext{
	my ($self,$event) = @_;
	
	return undef if($self->{'destroying'});

	$self->{'pbutton'}->Enable(1);
	
	if(	$self->{'current_dlg'}->GetSkip () &&
		 defined $self->{'current_dlg'}->GetNext ()){
		
		$self->{'current_dlg'} = $self->{'current_dlg'}->GetNext ();
            Wx::PostEvent ($self,$self->{'nbutton_event'});
		return 1;
	}
		
	
	if(!$self->{chain_terminated} || !defined $self->{'current_dlg'}->GetNext ()){
		$self->{'nbutton'}->Enable(0);
	}
	
	if(defined $self->{'current_dlg'}){
		if($self->{'current_dlg'}->{'initialized'}){
			$self->setBusy(1);
			my $rc;
            eval { $rc = $self->{'current_dlg'}->Process($self->{'config'});};
            if ($@){
               return $self->handleException ($@);
            }
			return undef if($self->{'destroying'});
			$self->setBusy(0);
			if(defined $rc){
				$self->SetConfig($rc);
				if(defined $rc->{errstate} && $rc->{'errstate'} == 1){
					if(defined $rc->{'errmsg'}){
						my $msgbox;
						if(defined $rc->{'errdetail'}){
							$msgbox = Wx::MessageDialog->new($self,$rc->{'errdetail'},
								$rc->{'errmsg'}, wxICON_ERROR | wxCENTRE | wxOK);
						}
						else{
							$msgbox = Wx::MessageDialog->new($self,$rc->{'errmsg'},
								"Fatal Error", wxICON_ERROR | wxCENTRE | wxOK);
						}
						$msgbox->ShowModal();
						$msgbox->Destroy;
					}
					$self->{'error_state'} = 1;
					$self->{'config'}->{'error_state'} = 1;
					$self->gotoErrHandlerPage;
					return undef;
				}
				if(exists $rc->{'auto_retry'} and $rc->{'auto_retry'}){
					Wx::PostEvent ($self, $self->{nbutton_event});
					return 1;
				}	
				
				if(defined $rc->{'AddNewSteps'}){

					print ">>>>>>>> ERROR: AddNewSteps unsupported: $self->{current_dlg}\n"
				
				}
				
				if(!defined $self->{'current_dlg'}->GetNext ()){
					$self->{'nbutton'}->Show(0) unless $self->{'log_button_enabled'};
					$self->{'button_sizer'}->Detach ($self->{'cbutton'});
					$self->{'cbutton'}->Destroy ();
					if ($^O =~ /mswin/i){
						$self->{'cbutton'} = Wx::Button->new ($self,wxID_EXIT,'&Finish');
					}
					else{
						$self->{'cbutton'} = SDB::Install::Gui::Control::Button->new ($self,wxID_EXIT,'&Finish');
					}	
					$self->{'cbutton'}->SetFocus();
					#$self->{'button_sizer'}->AddSpacer (30);
					$self->{'button_sizer'}->Add($self->{'cbutton'},0, wxALIGN_CENTER_VERTICAL);
					$self->{'button_sizer'}->AddSpacer (5);
					EVT_BUTTON($self,wxID_EXIT,\&OnCancel);							 
									
					$self->{'nbutton'}->Enable(0) unless $self->{'log_button_enabled'};
					$self->{'pbutton'}->Enable(0);
					
					$self->{'button_sizer'}->Layout();
					
					$self->Layout;
					return 1;
				}
				else{
					if (!exists $self->{'current_dlg'}->GetNext ()->{'show_self_defined'}){
						if (exists $self->{'hold_dlg'} && defined  $self->{'hold_dlg'} ){
							$self->{'page_sizer'}->Detach ($self->{'hold_dlg'});
                                                        $self->{'hold_dlg'}->Show(0);
							delete $self->{'hold_dlg'};	
						}
						else{
							$self->{'page_sizer'}->Detach($self->{'current_dlg'});
							$self->{'current_dlg'}->Show(0);
						}	
					}
					else{
						$self->{'current_dlg'}->Enable(0);
						$self->{'hold_dlg'} = $self->{'current_dlg'};
					}
					
					$self->{'current_dlg'} = $self->{'current_dlg'}->GetNext ();
					if (exists $rc->{'deny_back'} and $rc->{'deny_back'}){
						$self->KillPreviousDialogs ();
						
					}
								
					if($self->{'instmode'}){
						$self->{'pbutton'}->Show(0);
					}
					Wx::PostEvent ($self, $self->{nbutton_event});
					return 1;
				}
			}
			else{
				$self->{'current_dlg'}->Enable(1);
				return 0;
			}
		}
		else{
			$self->initDialog ();
		}
	}
	#$self->{'nbutton'}->Enable(1);
	$self->SetDefaultFocus;
	return 1;
}

sub SetDefaultFocus{
	my ($self) = @_;
    if (defined $self->{current_dlg}){
        $self->{current_dlg}->SetFocus ();
    }

    if ($isApple && !$self->IsShownOnScreen()){
        return 1;
    }

	if($self->{'nbutton'}->IsEnabled){
		$self->{'nbutton'}->SetDefault ();
	}
	elsif($self->{'pbutton'}->IsEnabled and $self->{'pbutton'}->IsShown){
		$self->{'pbutton'}->SetDefault ();
	}
	else{
		$self->{'cbutton'}->SetDefault ();
	}
}
	
sub OnCancel{
	my ($self,$event) = @_;

	if(Wx::GetTopLevelParent($self)->can('EndModal')){
		my $dlg = Wx::GetTopLevelParent($self);
		
		if($self->{'cbutton'}->GetId == wxID_EXIT){
			$dlg->EndModal(1);		
		}
		else{
			
			$dlg->Close();
		}
	}
	elsif($self->{'cbutton'}->GetId == wxID_EXIT){
		Wx::GetTopLevelParent($self)->Close(1);
	}
	else{
		Wx::GetTopLevelParent($self)->Close();
	}
}

sub SetInstallMode{
	my ($self,$enable,$label) = @_;
	if($enable != 0){
		return if $self->{'instmode'}; 
		$self->{'orig_nextbutton_label'} = $self->{'nbutton'}->GetLabel();
		$self->{'nbutton'}->SetLabel(defined $label ? $label : "&Install");
		$self->{'instmode'} = 1;
	}
	else{
		return unless $self->{'instmode'}; 
		$self->{'pbutton'}->Show(1);
		if (defined $self->{'orig_nextbutton_label'}){
			$self->{'nbutton'}->SetLabel ($self->{'orig_nextbutton_label'});
		}
		delete $self->{'instmode'};
	}
	$self->{'btn_sizer'}->Layout ();
}

sub SetRetryMode{
	my ($self,$enable) = @_;
	if($enable != 0){
		return if $self->{'retrymode'}; 
		$self->{'retrymode'} = $self->{'nbutton'}->GetLabel;
		$self->{'nbutton'}->SetLabel("&Retry");
		$self->{'nbutton'}->Enable(1);
	}
	else{
		return unless $self->{'retrymode'}; 
		$self->{'nbutton'}->SetLabel($self->{'retrymode'});
		$self->{'nbutton'}->Enable(0);
		delete $self->{'retrymode'};
	}
	$self->{'btn_sizer'}->Layout();
}


sub LogButton{
	my ($self,$label,$evt_handler) = @_;

	my $oldId = $self->{'nbutton'}->GetId;
	EVT_BUTTON($self,$oldId,sub{});

	$self->{'nbutton'}->SetLabel($label);
	$self->{'nbutton'}->SetId (Wx::Window::NewControlId (1));
	EVT_BUTTON($self,$self->{'nbutton'}->GetId,$evt_handler);
	if($self->{'pbutton'}->IsShown){
		$self->{'pbutton'}->Show(0);
	}
	
	unless ($self->{'nbutton'}->IsShown){
		$self->{'nbutton'}->Show(1);
	}	
	
	unless ($self->{'nbutton'}->IsEnabled){	
		$self->{'nbutton'}->Enable(1);
	}

	my $nbutton_minsize = $self->{'nbutton'}->GetBestSize();
	$self->{'btn_sizer'}->SetItemMinSize(1,$nbutton_minsize->GetWidth, $nbutton_minsize->GetHeight);
	$self->Layout;
	$self->{'log_button_enabled'} = 1;
}

#>---------------------------------Seek&Destroy Stuff------------------------------------------<#

sub Destroy{
	my ($self) = @_;
	$self->{'destroying'} = 1;
    $self->KillDialogs;
    
    #
    #   Destroy Sizer
    #

    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }
    
    #
    #   Destroy elements
    #

    foreach my $element (  'nbutton',
                        'pbutton',
                        'cbutton',
                        'hbutton',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
   
	$self->SUPER::Destroy;
}


sub PrintLinkedList{
	my ($self) = @_;
	my $dlg = $self->{current_dlg};
	
	if (!defined $dlg){
		print '<EMPTY>';
		return 1;
	}
	
	#
	# find first
	#
	
	while (1){
		if (!defined $dlg->GetPrevious()){
			last;
		}
		$dlg = $dlg->GetPrevious();
	}
	
	while (defined $dlg){
		print $dlg->GetID() . ($dlg->GetSkip ? '(SKIPPED)' : '');
		
		if (defined $dlg->GetNext()){
			print "->";
			$dlg = $dlg->GetNext();
			next;	
		}
		last;
	}
	print "\n";	
}


sub CheckLinkedList{
	my ($self) = @_;
	my $dlg = $self->{current_dlg};
	
	if (!defined $dlg){
		print '<EMPTY>';
		return 1;
	}
	
	#
	# find first
	#
	
	while (1){
		if (!defined $dlg->GetPrevious()){
			last;
		}
		$dlg = $dlg->GetPrevious();
	}
	
	while (defined $dlg){
		if (defined $dlg->GetNext()){
			if ($dlg->GetNext()->GetPrevious () ne $dlg){
				print ">>>>> ERROR between ". $dlg->GetID. " and " .$dlg->GetNext()->GetID().': ' . $dlg->GetNext()->GetPrevious ()->GetID()."\n"; 
			}
			
			$dlg = $dlg->GetNext();
			next;	
		}
		last;
	}
}

sub EnableNextButton{
	$_[0]->{nbutton}->Enable (1);
	$_[0]->{nbutton_disabled} = 0;
}

sub DisableNextButton{
	$_[0]->{nbutton}->Enable (0);
	$_[0]->{nbutton_disabled} = 1;
}

sub EnableNavigationControls {
	my ($self, $enable) = @_;
	$self->{nbutton}->Enable($enable);
	$self->{pbutton}->Enable($enable);
	$self->{cbutton}->Enable($enable);
}


sub DESTROY{
	my ($self) = @_;
    print ">>>> DESTROY $self\n"
    if defined $SAPDB::Install::DEBUG::DESTRUCT &&
        $SAPDB::Install::DEBUG::DESTRUCT;
}


1;
