package SDB::Install::HdbInstallerOutputParser;

use strict;
use SDB::Install::MsgLst;
use base 'Exporter';

our @EXPORT = qw (parseHdbInstallerErrorMessages);

sub parseHdbInstallerErrorMessages{
    my ($outputLines) = @_;
    my $msglst = new SDB::Install::MsgLst ();
    if (!defined $outputLines){
        return $msglst;
    }

    my $summary_found = 0;
    my @msglstStack = ($msglst);
    my ($spaces,$msgText);
    my ($currentLevel, $newLevel, $lastMsg, $errorLevel);
    my $errorPattern = 'failed|error|cannot|^\s*bash:';
    foreach my $line (@$outputLines){
        if (defined $errorLevel){
            ($spaces, $msgText) = ($line =~ /^(\s*)(\S.*)$/);
            $newLevel = (defined $spaces) ? length ($spaces) / 2 : 0;
            $currentLevel = $#msglstStack + $errorLevel;
            if ($errorLevel < $newLevel){
                if ($newLevel < $currentLevel){
                    pop (@msglstStack);
                }
                elsif ($newLevel > $currentLevel){
                    push @msglstStack, $lastMsg->getSubMsgLst ();
                }
                $lastMsg = $msglstStack[$#msglstStack]->addMessage ($msgText);
                next;
            }
            else{
                $errorLevel = undef;
            }
        }
        if ($line =~ /$errorPattern/i){
            ($spaces, $msgText) = ($line =~ /^(\s*)(\S.*)$/);
            $errorLevel = length ($spaces) / 2;
            @msglstStack = ($msglst);
            $lastMsg = $msglst->addMessage ($msgText);
        }
    }
    return $msglst;
}

1;
