package SDB::Install::Installation::OfficeClient;

use SDB::Install::Installation;
use SDB::Install::SysVars qw ($path_separator $isWin);
use SDB::Install::Globals qw ($gProductNameOfficeClient $gShortProductNameOfficeClient);
use SDB::Install::Installation::Client;
use SDB::Install::System qw (removeUninstallEntry);
use strict;

#----------------------------------------------------------------------------

our @ISA = qw (SDB::Install::Installation::Client);

#----------------------------------------------------------------------------


our $regFileName = 'installations.officeclient';


our $installations;

sub new {
    return shift->SUPER::new (@_);
}

#----------------------------------------------------------------------------

sub EnumOfficeClientInstallations{
    my ($msglst, $nocache) = @_;
    if (defined $installations && !$nocache){
        return $installations;
    }
    my $obj = new __PACKAGE__;
    $installations = $obj->EnumInstallations ();
    return $installations;
}

#----------------------------------------------------------------------------

sub getRegFileName {
    return $regFileName;
}

#----------------------------------------------------------------------------

sub asString{
    my ($self) = @_;
    return "$gProductNameOfficeClient " . $self->GetVersion () . ' ' . $self->{path};
}


#----------------------------------------------------------------------------

sub Unregister{
    my $self = shift;
    my $rc = $self->SUPER::Unregister (@_);
    my $msglst = new SDB::Install::MsgLst ();
    if (!defined removeUninstallEntry ('HDBOFFICECLIENT', 0, undef, $msglst)){
        #$self->PushError ('Cannot remove uninstall entry', $msglst);
        #return undef;
    }
    return $rc;
}

#----------------------------------------------------------------------------

1;
