package SDB::Install::Kit::Client;

use strict;
use warnings;
use parent 'SDB::Install::Kit';

use SDB::Install::System qw(isLink);

sub copyLstFile {
    my ($self, $package) = @_;
# Avoid copying the LST files for the client
    return 1;
}

sub Install {
	my ($self) = @_;
	my $installation = $self->{installation};
	my $sapmntSymlink = $installation->getSapmntSymlinkPath();
	if ($installation->isSapmntInstallation() && $self->skipInstallationSteps() && !isLink($sapmntSymlink)) {
		return undef if (!$installation->updateSapmntSymlink());
	}
	return $self->SUPER::Install();
}

1;