package SDB::Install::LSS::LssUserConfig;

use strict;
use warnings;

use parent qw(SDB::Install::Base);
use SDB::Common::Utils qw(getSidcryptName);

sub new {
    my($class,$sapsys) = @_;
    my $self = bless ({},$class);
    $self->{sapsys} = $sapsys;
    return $self;
}

sub storeUserInfo {
    my($self,$user) = @_;

    if(!$user->exists()){
        $self->setErrorMessage("Cannot write data to user config as '".$user->getname()."' doesn't exist");
        return undef;
    }
    my $userData = {
        "sidcrypt_id" => $user->id(),
        "sidcrypt_gid" => $user->gid(),
        "sidcrypt_home" => $user->home(),
        "sidcrypt_shell" => $user->shell(),
        "sidcrypt_group" => $user->group(),
    };

    $self->getMsgLst()->addMessage("Writing '".$user->getname()."' user to user config...");
    if(!$self->{sapsys}->saveConfig($userData)){
        $self->setErrorMessage ("Writing '".$user->getname()."' user to user config failed");
        return undef;
    }
    return 1;
}

sub _getUserConfig {
    my ($self) = @_;
    my $userConfigurationFile = $self->{sapsys}->getUserConfig();
    if (!defined $userConfigurationFile){
        $self->setErrorMessage(undef, $self->{sapsys}->getErrMsgLst());
        return undef;
    }
    return $userConfigurationFile;
}

sub getUID {
    my ($self) = @_;
    my $userConfigurationFile = $self->_getUserConfig();
    return undef if (!defined $userConfigurationFile);
    my $uid = $userConfigurationFile->{sidcrypt_id};
    if(!$uid){
        $self->setErrorMessage("Cannot read '".getSidcryptName($self->{sapsys}->get_sid())."' user id from configuration");
        return undef;
    }
    return $uid;
}

sub getGID {
    my ($self) = @_;
    my $userConfigurationFile = $self->_getUserConfig();
    return undef if (!defined $userConfigurationFile);
    my $gid = $userConfigurationFile->{sidcrypt_gid};
    if(!$gid){
        $self->setErrorMessage("Cannot read '".getSidcryptName($self->{sapsys}->get_sid())."' group id from configuration");
        return undef;
    }
    return $gid;
}

sub getShell {
    my ($self) = @_;
    my $userConfigurationFile = $self->_getUserConfig();
    return undef if (!defined $userConfigurationFile);
    return $userConfigurationFile->{sidcrypt_shell};
}

sub getHome {
    my ($self) = @_;
    my $userConfigurationFile = $self->_getUserConfig();
    return undef if (!defined $userConfigurationFile);
    return $userConfigurationFile->{sidcrypt_home};
}

sub getGroupName {
    my ($self) = @_;
    my $userConfigurationFile = $self->_getUserConfig();
    return undef if (!defined $userConfigurationFile);
    return $userConfigurationFile->{sidcrypt_group};
}

1;
