package SDB::Install::LSS::Registrator::ComponentRegistratorBase;

use strict;
use warnings;
use SDB::Install::Globals qw($gShortProductNameLSS);
use parent qw(SDB::Install::LSS::LssConfigExecutor);

use File::Basename;
use File::Temp;
use File::Spec;
use File::stat;
use SDB::Install::System qw(listDir copy_file isDirectory setFilePermissions);
use SDB::Common::BuiltIn;

sub getProgressMessage {
    my $self = shift;
    return "Registering ".$self->getComponent()->getComponentName()." binaries in $gShortProductNameLSS";
}

sub _getSignaturePath {
    my($self) = @_;
    my $component = $self->getComponent();
    my $signature = $component->getSignature();
    return undef if(!defined $signature);
# Skip base class's belongsToComponent check
# for installed components because it doesn't work.
    return undef if(!$component->isInstalled() && !$signature->belongsToComponent($component));
    return $signature->getSignatureFilePath();
}

sub _createTmpDir {
    my ($self) = @_;
    my $component = $self->getComponent();
    my $manifest    = $component->getManifest();
    my $checksumDir = $component->getChecksumDir();

    local %ENV = %ENV;
    my $config = $self->getConfiguration();
    my $instance = $config->getOwnInstance(1);
    if (!$instance) {
        $self->getMsgLst()->addMessage("Could not retrieve instance object. Will default to use first entry of \$ENV{TMPDIR} or '/tmp' for temporary files location.");
    } else {
        # set parent dir for File::Temp->newdir()
        $ENV{TMPDIR} = $instance->get_globalSidDir();
    }
    my $tmpDir = File::Temp->newdir();
    my $builtIn = SDB::Common::BuiltIn->get_instance();
    $builtIn->chmod(0755, $tmpDir);

    my $checksumDirContents = listDir($checksumDir);
    my $msgLst = SDB::Install::MsgLst->new();
    my $rc = 1;
    for my $file (@$checksumDirContents) {
        next if (isDirectory($file) || $file !~ /\.lst$/);
        my $filePath = File::Spec->catfile($checksumDir, $file);
        $rc &&= copy_file($filePath, $tmpDir, $msgLst);
    }

    my $manifestPath = $manifest->getFileName();
    $rc &&= copy_file($manifest->getFileName(), $tmpDir, $msgLst);

    my $signaturePath = $self->_getSignaturePath();
    if (defined $signaturePath) {
        $rc &&= copy_file($signaturePath, $tmpDir, $msgLst);
    }

    if (!$rc) {
        $self->getErrMsgLst()->addError("Failed to create temporary files", $msgLst);
        return undef;
    }

    my $tmpDirContents = listDir($tmpDir);
    for my $file (@$tmpDirContents) {
        my $filePath = File::Spec->catfile($tmpDir, $file);
        if (!setFilePermissions(0644, $filePath, $msgLst)) {
            $self->getErrMsgLst()->addError("Failed to amend permissions of temporary files", $msgLst);
            return undef;
        }
    }
    return $tmpDir;
}

1;