package SDB::Install::LayeredConfig;

use SDB::Install::BaseLegacy;
use SDB::Install::SysVars qw ($path_separator $isWin);
use SDB::Install::LayeredConfig::IniFile;
use SDB::Install::LayeredConfig::NameserverFile;
use strict;
use Exporter;

our @ISA = qw (SDB::Install::BaseLegacy Exporter);

our @EXPORT = qw(
	CFG_LAYER_DEFAULT
	CFG_LAYER_SYSTEM
	CFG_LAYER_TENANT
	CFG_LAYER_HOST
);

sub CFG_LAYER_DEFAULT {$CFG_LAYER_DEFAULT}
sub CFG_LAYER_SYSTEM {$CFG_LAYER_SYSTEM}
sub CFG_LAYER_TENANT {$CFG_LAYER_TENANT}
sub CFG_LAYER_HOST {$CFG_LAYER_HOST}

our $inifile_ini = 'inifiles.ini';

sub new {
	my $self = shift->SUPER::new ();
	my ($instance_root,$sys_root,$tenant,$host,$configDir,$uid,$gid) = @_;
	$self->{layer} = [
		(defined $configDir ? $configDir : join ($path_separator, $instance_root, 'exe','config')),
		join ($path_separator, $sys_root, 'global', 'hdb', 'custom' ,'config'),
		(defined $tenant ? join ($path_separator, $instance_root, $tenant) : undef),
		(defined $host ? join ($path_separator, $instance_root, $host) : undef)
	];
	
	if (!$isWin){
		$self->{uid} = $uid;
		$self->{gid} = $gid;
	}
	
	
	$self->readIni();
	return $self;
}

sub readIni{
	my ($self,$reload) = @_;

	if (defined $self->{data} && (!defined $reload || !$reload)){
		return 1;
	}
	
	my $file = join ($path_separator, $self->{layer}->[0],
		$inifile_ini);
	if (!open (FD, $file)){
		$self->AddError ("Cannot open file '$file': $!");
		return undef;
	}
	my $line;
	my %data;
	my $section;
	my $ini;
	my ($key,$value);
	my $flag;
	while ($line = <FD>){
		if ($line =~ /^\s*#/){
			next;
		}
		chomp ($line);
		
		$line =~ s/^\s*//;
		$line =~ s/\s*$//;
		if (!$line){
			next;
		}
		if ($line =~ /^\[.*\]$/){
			($section) = ($line =~ /^\[(.*)\]$/);
			my @section = split (':', $section);
			if ($section[0] eq 'file'){
				$ini = $section[1];
			}
			if (!defined $data{$ini}){
				$data{$ini} = [0,{}];
			}
			next;
		}
		
		if ($line =~ /\S.*=/){
			($key,$value) = split ('=',$line);
			$key =~ s/\s*$//;
			$value =~ s/^\s*//;
			if ($key){
				$flag = undef;
				if ($key eq 'layered'){
					$flag = $CFG_IS_LAYERED;
				}
				elsif ($key eq 'default'){
					$flag = $CFG_LAYER_DEFAULT;
				}
				elsif ($key eq 'system'){
					$flag = $CFG_LAYER_SYSTEM;
				}
				elsif ($key eq 'tenant'){
					$flag = $CFG_LAYER_TENANT;
				}
				elsif ($key eq 'host'){
					$flag = $CFG_LAYER_HOST;
				}
				else{
					$data{$ini}->[1]->{$key} = $value;
				}
				
				if (defined $flag){
					if ($value eq 'yes'){
						$data{$ini}->[0] |= $flag;
					}
					elsif ($value eq 'no'){
						$data{$ini}->[0] &= ~$flag;
					}
				}
			}
			next;
		}
	}
	close (FD);
	$self->{data} = \%data;
	return 1;
}

sub getIniFile{
	my ($self,$file) = @_;
	if (!exists $self->{data}->{$file}){
		$self->AddError ("Inifile '$file' is unknown");
		return undef;
	}
	return new SDB::Install::LayeredConfig::IniFile (
		$file,
		$self->{data}->{$file},
		$self->{layer},
		$self->{uid},
		$self->{gid});
}

sub getNameserverFile{
    my ($self,) = @_;
    my $file = 'nameserver.ini';
    if (!exists $self->{data}->{$file}){
        $self->AddError ("Nameserver '$file' is unknown");
        return undef;
    }

    return new SDB::Install::LayeredConfig::NameserverFile (
        $file,
        $self->{data}->{$file},
        $self->{layer},
        $self->{uid},
        $self->{gid});
}



1;
