#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Tree view for text content view. Inherit from Wx::TreeCtrl.

package SDB::Install::LogViewer::Control::XLVTreeCtrl;
use strict;

our @ISA = qw (Wx::TreeCtrl);

use Wx qw (wxRED wxCYAN wxBLACK wxTR_MULTIPLE);

my $warningcolour = Wx::Colour->new(242, 170, 0);
my $errorcolour = wxRED;

my $TESTITEMTEXT = '_TESTITEM_';

sub new{
    my($self ) = shift->SUPER::new(@_);
    $self->SetWindowStyleFlag ($self->GetWindowStyleFlag() | wxTR_MULTIPLE);
    return $self;
}

sub InitiateTree {
    my($self, $cache) = @_;
    
    if (!defined $self->{cachetree}) {
        
        #initiate treectrl view
        
        $self->DeleteAllItems();
        
        $self->{cachetree} = $cache->GetCacheTree;
        
        # add root
        my $cacheNode = $self->{cachetree}->GetRootItem();
        my $treeNode = $self->AddRoot( $cacheNode->GetText );
        
        $self->SetPlData($treeNode, $self->{cachetree}->GetPlData($cacheNode));

        if ($cacheNode->HasChildren) { $self->SetItemHasChildren($treeNode,1); }
        
        $self->Expand ( $treeNode, $cacheNode );
        $self->SUPER::Expand($treeNode);
        
        $self->SelectItem($treeNode,1);
        
        $self->LayoutIt();
    }
    
    1;
}

sub Reset {
     my($self) = @_;
     delete $self->{cachetree};  
}

# expand from the given node
sub Expand {
    my($self, $treeParentNode, $cacheNode) = @_;

    # if cacheNode unknown then ask the cache with id    
    if (!defined $cacheNode) {
        my $result = $self->GetPlData($treeParentNode);
        return 0 if (!defined $result);
        if (exists $result->{id}) {
            $cacheNode = $self->{cachetree}->GetItemById ( $result->{id} );
        } else { return; }
    }
    
    # Set expand attribute
    my $tmpdata = $self->{cachetree}->GetPlData( $cacheNode );
    
    # put children if realy matter
    if (($self->{cachetree}->HasChildren( $cacheNode ) ) && ((!exists $tmpdata->{'Expand'}) || ($tmpdata->{'Expand'} == 0))) {
        $tmpdata->{'Expand'} = 1;
        $self->{cachetree}->SetPlData( $cacheNode, $tmpdata );
        
        #append children with filter!
        my ($node, $cookie) = $self->{cachetree}->GetFirstChild( $cacheNode );
        
        while( defined $node )
        {
            #filter
            if (!$self->{cachetree}->IsFiltered($node)) {
                #add
                my $newItem = $self->AppendItem($treeParentNode, $self->{cachetree}->GetItemText($node));
                $self->SetPlData($newItem, $self->{cachetree}->GetPlData($node));

                #set plus
                if ($self->{cachetree}->HasChildren($node)) { $self->SetItemHasChildren($newItem,1); }    
            }
                
            #get next child
            ($node,$cookie) = $self->{cachetree}->GetNextChild( $cacheNode, $cookie );
        }        
    }
    
    1;
}

#------------------ Layout ---------------------

##
# Make tree beautiful
##
#our $ultimatecounter = 0;
#our $ultimateerrors = 0;
#our $ultimatewarnings = 0;

sub LayoutIt () {
    my ($self) = @_;

    #reset layout
    $self->ResetLayout( $self->GetRootItem );
    
    #expand until 2 layer, make bold until 2 layer
    $self->MakeBeautiful( $self->GetRootItem, 0 );

    #make error and warnings visible
#print "ShowProblems\n";
#print "TreeCount: ".$self->GetCount()."\n";
#$ultimatecounter = 0;
#$ultimateerrors = 0;
#$ultimatewarnings = 0;
    
    if ($self->ShowProblems( $self->{cachetree}->GetRootItem() ) == 1) {
        $self->SetItemTextColour($self->GetRootItem, wxRED);
        $self->SetItemBold($self->GetRootItem,1);
    }
#print "TreeCount: ".$self->GetCount()."\n";
#print "Counter: $ultimatecounter\n";
#print "Warnings: $ultimatewarnings\n";
#print "Errors: $ultimateerrors\n";
    #scroll to top
    $self->ScrollTo($self->GetRootItem());
    1;
}


##
# Resets the layout of the tree
#
# @param
#   scalar item - TreeNodeItem
##

sub ResetLayout() {
    my ($self, $parent) = @_;
    
    return if (!defined $parent) || (!$parent->IsOk());
    
    $self->SetItemTextColour($parent, wxBLACK);
    $self->SetItemBold($parent,0);
    
    my ($item, $cookie) = $self->GetFirstChild( $parent );
    while( $item->IsOk() )
    {
        $self->ResetLayout($item);      
        ($item,$cookie) = $self->GetNextChild( $parent, $cookie );
    }
    
    1;
}

##
# Make this tree beautiful traverse method.
#
# @param
#   scalar item - TreeNodeItem
#   scalar deep - deep counter
##

sub MakeBeautiful() {
    my ($self, $parent, $deep) = @_;

    $deep += 1;
    if ($deep > 2) {return 1; }
    
    $self->LayoutLeafs($parent, $deep);
    
    #Go very deep in structure to the leafs...
    my ($item, $cookie) = $self->GetFirstChild( $parent );
    while( $item->IsOk() )
    {
        $self->MakeBeautiful($item, $deep);        
        ($item,$cookie) = $self->GetNextChild( $parent, $cookie );
    }

    1;
}


##
# This method layouts the current tree item.
#
# @param
#   Wx::TreeItemId item - item to check
#   scalar deep - deep counter
##

sub LayoutLeafs () {
   my ($self, $item, $deep) = @_;
   
   if ($item->IsOk()){
       # set bold
       if ($deep <= 2) {
           $self->SetItemBold($item, 1);
       }
       # set expand
       if  ($deep <= 3) {
           $self->Expand($item);
           $self->SUPER::Expand($item);
       } else {
           $self->Collapse($item);
       }
    }
    1;
}


##
# Traverse tree and show warnings and errors.
#
# @param
#   scalar $cacheNodeParent - CacheTree parent node 
##

sub ShowProblems() {
    my ($self, $cacheNodeParent) = @_;

    #check for filter
    if ($self->{cachetree}->IsFiltered($cacheNodeParent)) { return; }

    #Go very deep in structure to the leafs...
    my ($item, $cookie) = $self->{cachetree}->GetFirstChild( $cacheNodeParent );
    my $result = 0;
    while( defined $item )
    {
        $result = $self->ShowProblems($item);
        ($item, $cookie) = $self->{cachetree}->GetNextChild( $cacheNodeParent, $cookie );
    }

    return $self->LayoutErrorAndWarnings($cacheNodeParent) || $result;
}


##
# This method layouts the current tree item
# for warnings and errors.
#
# @param
#   TreeElement item - item to check
##
             
sub LayoutErrorAndWarnings () {
   my ($self, $item) = @_;
   if (defined $item){
       # set red for error
       my $data = $self->{cachetree}->GetPlData($item);
       if (defined $data->{'_TYPE'}) {
           if ($data->{'_TYPE'} eq 'Warning') {
               #WARNING: THIS METHOD NEEDS A LOT OF TIME!
               #$self->ExpandToParent($item, $warningcolour, 0 );
#               $ultimatewarnings++;
                return 1;
           }
           if ($data->{'_TYPE'} eq 'Error') {
               #WARNING: THIS METHOD NEEDS A LOT OF TIME!
               #$self->ExpandToParent($item, $errorcolour, 1 );
#               $ultimateerrors++;
                return 1;
           }
       }
    }
    return 0;
}


##
# Expand the given cache node in the xlvtreeto the root node.
#
# @param
#   TreeElement cacheNode - item to check
#   Wx::Colour wxcolour   - colour
#   Scalar bold           - boolean bold
##

sub ExpandToParent {
    my ($self, $cacheNode, $wxcolour, $bold) = @_;

    my @hierarchy=();
    
    # go to cache root and save all cache nodes
    my $node = $cacheNode;
    while ((defined $node) && ($node ne "ROOT")) {
        push @hierarchy, $node;
        $node = $self->{cachetree}->GetItemParent ($node);
    }
    
    # expand the xlvtree to the found node
    my $xlvItem = $self->GetRootItem();
    my $notRoot = 0;
	my $cacheItem;
    while ($cacheItem = pop @hierarchy) {
            
        if ($notRoot == 1) {
           # set fitting xlvItem
           my $itemId = $self->{cachetree}->GetItemId($cacheItem);
           my $found = undef;
           my ($xlvchild, $cookie) = $self->GetFirstChild( $xlvItem );
           while( $xlvchild->IsOk() )
           {
               my $itemData = $self->GetPlData($xlvchild);
               if ((exists $itemData->{id}) && ($itemData->{id} eq $itemId)) {
                    $found = $xlvchild;
                    last;
               }
               ($xlvchild,$cookie) = $self->GetNextChild( $xlvItem, $cookie );
           }
           $xlvItem = $found;
        }

        last if (!defined $xlvItem || !$xlvItem->IsOk());           

        if (!$self->IsExpanded ($xlvItem)) {
 #           $ultimatecounter++;
            $self->Expand($xlvItem, $cacheItem);
            $self->SUPER::Expand($xlvItem);
        }
        if (defined $wxcolour) {$self->SetItemTextColour($xlvItem, $wxcolour);}
        $notRoot = 1;
    }      
    
    if (defined $bold) { $self->SetItemBold($xlvItem, $bold);   }
    
    return $xlvItem;
}

#>-------------------- Tree Select -----------------


##
# Forced tree node selection method.
# if you want to select a specific node, use this.
#
# @param
#   Wx::TreeItemId treenode - node id to select
##

sub SelectTreeNode {
    my ($self, $treenode) = @_;
    return unless $treenode;
    return if ($treenode < 0);
    
    $self->SelectItem($treenode);
    
    1;
}

sub SelectBestTreeNodeBySourceline() {
    my ($self, $line) = @_;
    return unless $line;
    return if ($line < 0);
    my $result_node;
    my $tmpline = 0;
    
    #
    #   Search for line in cache
    #
    
    my $nodeCache = $self->{cachetree}->GetNodeCache();
    #attantion: unsorted!
	my ($id,$node);
    #while (($id, $node) = each %${$nodeCache}) {
    foreach $id (0 .. (@$nodeCache - 1)){
	    $node = $nodeCache->[$id];
		my $data = $self->{cachetree}->GetPlData($node);
        if (defined $data->{'Sourceline'}) {
            if (($data->{'Sourceline'} <= $line) && ($data->{'Sourceline'} > $tmpline) && ((!exists $data->{filter}) || ($data->{filter} eq 'Require'))) {
                $result_node = $node;
                $tmpline = $data->{'Sourceline'};
            }
        }
    }
    if (!defined $result_node) {return 1;}
    
    #
    #   Select cache node in tree, expand if not exist
    #
    
    my $xlvitem = $self->ExpandToParent($result_node);
    $self->SelectItem($xlvitem, 1);
    
    1;
}

#---------------------- Rest ----------------------------


##
# returns the item node text with hierarchy text of all parents
##

sub GetItemTextWithHierarchy() {
    my ($self, $treenode) = @_;
    my @result;
    while ($treenode->IsOk()) {
        push @result, $self->GetItemText($treenode);
        $treenode = $self->GetParent($treenode);
    }
    return @result;
}

#------------------ Seek & Destroy ------------------

sub Destroy{
    my ($self) = @_;
    $self->SUPER::Destroy;
}

1;
