#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Tree view for details. Inherit from Wx::TreeCtrl.

package SDB::Install::LogViewer::Control::XLVTreeDetailsCtrl;
use strict;
use Wx;
our @ISA = qw (Wx::TreeCtrl);

##
# Boring Constructor
#
# @return 
#   Wx::Dialog  - this tree control
##

sub new{
	my($this ) = shift->SUPER::new(@_);
	return $this;
}


##
# Fill the tree with data.
#
# @param
#   scalar data - reference to hash with content informations
##

sub FillDetails() {
   my ($self, $data) = @_;
  # kill 'em all
   $self->DeleteAllItems();
   
   # set root
   my $rootNode = $self->AddRoot("Details");
   
   # set children notes
   for my $key (keys %{$data}) {
		next if $key eq 'id' || $key eq 'Expand';
       # only if they start with underline
       $self->AppendItem ($rootNode, "$key = ".$data->{$key});
   }
   
   # expand tree for better view
   $self->Expand($rootNode);
   
   1;
}

#---------------------- Rest ----------------------------


##
# returns the details
##

sub GetDetailsAsText() {
    my ($self) = @_;
    my @result;
    my $root = $self->GetRootItem();
    
    my ($child, $cookie) = $self->GetFirstChild( $root );
    while( $child->IsOk() ) {
        push @result, $self->GetItemText($child);
        ($child,$cookie) = $self->GetNextChild( $root, $cookie );
    } 
    
    return @result;
}

#------------------ Seek & Destroy ------------------


##
# Death bringer method.
##

sub Destroy{
	my ($self) = @_;
	$self->SUPER::Destroy;
}

1;