#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Dialog of the log viewer. 

package SDB::Install::LogViewer::Dialog::XLVDialog;

use vars qw(@ISA);

@ISA=qw(Wx::Dialog);

use Wx qw( 
           wxTE_MULTILINE
           wxLI_HORIZONTAL
           wxEXPAND
           wxMAXIMIZE_BOX
           wxMINIMIZE_BOX
           wxTE_READONLY 
           wxALL
           wxRESIZE_BORDER
           wxDEFAULT_DIALOG_STYLE
         );

use Wx::Event qw(
       EVT_CLOSE
       EVT_BUTTON
       EVT_INIT_DIALOG
       );


use SDB::Install::LogViewer::Window::XLVWindow;


##
# Constructor
# This method create dialog structur, set initial values and get some important
# objects like Find and FilterHandler.
#
# @params
#   scalar      - titel string
#   Wx::Point   - position
#   Wx::Size    - size
#
# @return 
#   Wx::Dialog  - this dialog
##

sub new {
    my( $class ) = shift;
    my ($self) = $class->SUPER::new( undef, -1, $_[1], $_[2], $_[3], wxRESIZE_BORDER | wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxMINIMIZE_BOX );
    
    my $masterSizer = Wx::FlexGridSizer->new(2,1,5,5);

    #
    #   Window
    #
    
    $self->{'window'} = SDB::Install::LogViewer::Window::XLVWindow->new ($self);
    $self->{'window'}->Show(1);
    $masterSizer->Add ($self->{'window'}, 1, wxEXPAND | wxALL, 5);
    
    #
    #   Horizontal Line
    #
    
    $self->{'masterline'} = Wx::StaticLine->new( $self, -1, [-1,-1], [-1,2], wxLI_HORIZONTAL);
    $masterSizer->Add ($self->{'masterline'}, 1, wxEXPAND ,);
    
    #
    #   Global Buttons
    #
    
    my $buttonsSizer = Wx::FlexGridSizer->new(1,3,5,5);
    $self->{'load_button'} = Wx::Button->new($self,-1,'Load Log File');
    $self->{'exit_button'} = Wx::Button->new($self,-1,'Close');
    $self->{'msg_StaticBox'} = Wx::StaticBox->new ($self,-1,'');
    $self->{'msg_label'} = Wx::TextCtrl->new ($self, -1, '', [-1,-1],[-1,20], wxTE_MULTILINE | wxTE_READONLY );
    $self->{'msg_label'}->SetBackgroundColour ($self->{'msg_StaticBox'}->GetBackgroundColour());
    $self->{'msg_StaticBox'}->Destroy();
    delete $self->{'msg_StaticBox'};
    
    $buttonsSizer->Add ($self->{'load_button'},1,   wxALL, 5);
    $buttonsSizer->Add ($self->{'msg_label'},1,wxEXPAND | wxALL,5 );
    $buttonsSizer->Add ($self->{'exit_button'},1,  wxALL, 5);
    $buttonsSizer->AddGrowableCol( 1 );
    $masterSizer->Add ($buttonsSizer, 1, wxEXPAND);
    
    $masterSizer->AddGrowableRow( 0 );
    $masterSizer->AddGrowableCol( 0 );
    $self->SetSizerAndFit($masterSizer);
    
    #---------Events------------

    #
    #   Dialog events
    #
    
    EVT_CLOSE( $self, \&OnClose );
    EVT_BUTTON( $self, $self->{'exit_button'}->GetId(), \&OnClose );
    EVT_BUTTON( $self, $self->{'load_button'}->GetId(), \&OnLoad ); 
    
    #
    #   Init Dialog
    #
    
    EVT_INIT_DIALOG ($self, \&OnInitDialog ); 

    #--------Other Stuff---------
    
    $self->SetAutoLayout(1);
    $self->Layout();
    
    $self;
}


#------------------------------- Delegater methods -----------------------------


##
# Set to load file after dialog is visible.
#
# @param
#   scalar scal - filename
##

sub LoadFileAfterShow {
    my( $self, $scal ) = @_;
    $self->{'window'}->LoadFileAfterShow($scal);
    1;
}


##
# Set to load content from scalar after dialog is visible.
#
# @param
#   scalar scal - scalar with content
##

sub LoadScalarAfterShow {
    my( $self, $scal ) = @_;
    $self->{'window'}->LoadScalarAfterShow($scal);
    1;
}

sub LoadMsgLstAfterShow {
	$_[0]->{'window'}->LoadMsgLstAfterShow($_[1]);
}




##
# Set to load explicit simple view content from scalar after dialog is visible.
#
# @param
#   scalar scal - scalar with plaint text for simple view
##

sub LoadPlainTextAfterShow {
    my( $self, $scal ) = @_;
    $self->{'window'}->LoadPlainTextAfterShow($scal);
    1;
}


##
# Load content from file.
# Do not call this method from an other modul.
#
# @param
#   scalar filename - filename
##

sub LoadFile {
    my ($self, $filename) = @_;
    $self->{'window'}->LoadFile($filename);
    1;
}

#------------------------------- gui methods ----------------------------

##
# Set message text to the Log-View logger.
#
# @param
#   scalar message - message text
#   scalar break   - make newline if defined
##

sub SetMessage () {
    my( $self, $message, $break ) = @_;
    my $tmp = $message;
    #$tmp = "~ ".(time - $lasttimestop)."\n".$tmp;
    $tmp = "\n".$tmp unless $break;
    
    #$lasttimestop = time;
    $self->{'msg_label'}->AppendText($tmp);

    # scroll down
    $self->{'msg_label'}->ShowPosition($self->{'msg_label'}->XYToPosition(0,$self->{'msg_label'}->GetLastPosition));    
    1;
}


##
# Event method if dialog start 
##

sub OnInitDialog {
    my ($self) = @_;
    $self->{'window'}->OnInit();
    1;
}

##
# Event method for loading file
##

sub OnLoad {
    my ($self,$evt) = @_;
    $self->{'window'}->OnLoad($evt);
	1;
}


#-------------------------- Rest in peace functions -----------------------


##
# Event method for close button.
##

sub OnClose {
  my( $this, $event ) = @_;
  $this->EndModal(1);
}


##
# I'm the death bringer method!
##

sub Destroy{
	my ($self) = @_;
	
    #
    #   Destroy Sizer
    #
    
    if(defined $self->GetSizer){
        $self->GetSizer->Clear (1);
    }

    #
    #   Destroy elements
    #

    foreach my $element (  
                        'window',
                        'msg_label',
                        'masterline',
                        'load_button',
                        'exit_button',
                      ) {
        if(defined $self->{$element}){
            delete $self->{$element};
        }
    }
    
	$self->SUPER::Destroy;
}

1;
