#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Comp filter class to filtering for _COMP attributes.

package SDB::Install::LogViewer::Filter::CompFilter;

use strict;

use vars qw(@ISA);

use SDB::Install::LogViewer::Filter::AbstractFilter;

our @ISA = qw (SDB::Install::LogViewer::Filter::AbstractFilter);

my $CAT = '_COMP'; # this attribute is program


##
# Constructor for initialization.
##

sub new{
	my($self ) = shift->SUPER::new();
	
	$self->{RequireOrExclude} = shift;
    $self->{CompName} = shift;   
    
	return $self;
}


##
# This method checks the current tree item
# for destroying. This method knows no pain.
#
# @param
#   TreeElement item - item to check
#   CacheTree cacheTree - CacheTree
##

sub CheckAndKill () {
   my ($self, $item, $cacheTree) = @_;
   if (defined $item){
        my $data = $cacheTree->GetPlData($item);
        if ($self->{RequireOrExclude} eq 'Require') {
            if (defined $data->{$CAT}) {
                if ($data->{$CAT} ne $self->{CompName} ) {
                    $data->{filter} = 'Exclude';
                }
            } else {
                $data->{filter} = 'Exclude';
            }
        } elsif($self->{RequireOrExclude} eq 'Exclude') {
           if (defined $data->{$CAT}) {
                if ($data->{$CAT} eq $self->{CompName} ) {
                    $data->{filter} = 'Exclude';
                } 
            } 
        }
        $cacheTree->SetPlData($item, $data);
    }
    1;
}


##
# Get the category.
#
# @return
#   scalar category
##

sub GetCatergory(){
    my ($self)=@_;
    return $CAT; 
}


##
# Get a beautiful string with attribute name and require state.
#
# @return
#   scalar string
##

sub ToString(){
    my ($self)=@_;
    return "Attribute: ".$self->{CompName}." #".$self->{RequireOrExclude}; 
}

1;