#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Handle all the filters.

package SDB::Install::LogViewer::Filter::FilterHandler;


#------------------------------EXPORT START

our @ISA = qw(Exporter);

our @EXPORT = qw(
    GetFilterTitelsAsAnRefArray
    );
    
# All filters must register here. It's for the dropdown menu.
our @Filternames =  ( 
                    '_COMP',
                    '_TYPE',
                    '_TIME',
                    );


##
# Get titels back of all known filters.
# 
# @return
#   reference to titel array
##

sub GetFilterTitelsAsAnRefArray() {
    return \@Filternames;
}

#------------------------------EXPORT END

use Wx qw(
        wxALIGN_CENTER_VERTICAL 
        wxLEFT
        wxCB_READONLY
        wxOK
        wxCENTRE
        wxICON_EXCLAMATION
        );

use Wx::Event qw(
       EVT_BUTTON
       );


my $filtercounter;


##
# Constructor
##

sub new () {
    my $invocant = shift;
    my $class = ref ($invocant) || $invocant;
    my $self;
    $filtercounter = 0;
    $self->{FILTERSTACK} = ();
    return bless ($self, $class);
}

##
# Start corresponding filter dialog.
#
# @param
#   scalar filtername   - name of the filter, see @Filternames
#   Cache cache - cache 
##

sub OpenFilterDialog() {
    my ($self, $filtername, $cache) = @_;
    if ($filtername eq '_COMP') {
        eval {
            require SDB::Install::LogViewer::Filter::CompDialog;
        };
        if ($@) {
           Wx::MessageBox( "Error: $@", 'Log Viewer Filter Error', wxOK | wxCENTRE | wxICON_EXCLAMATION, $self ); 
            return undef; # Stay in current dialog!
        } else {
            my ($frame) = SDB::Install::LogViewer::Filter::CompDialog->new( "$filtername Filter", Wx::Point->new(300,100), Wx::Size->new(320,200), $cache, $self );
            $frame->ShowModal();
            $frame->Destroy();    
        }
    }
    if ($filtername eq '_TYPE') {
        eval {
            require SDB::Install::LogViewer::Filter::TypeDialog;
        };
        if ($@) {
           Wx::MessageBox( "Error: $@", 'Log Viewer Filter Error', wxOK | wxCENTRE | wxICON_EXCLAMATION, $self ); 
            return undef; # Stay in current dialog!
        } else {
            my ($frame) = SDB::Install::LogViewer::Filter::TypeDialog->new( "$filtername Filter", Wx::Point->new(300,100), Wx::Size->new(320,200), $cache, $self );
            $frame->ShowModal();
            $frame->Destroy();    
        }
    }
    if ($filtername eq '_TIME') {
        eval {
            require SDB::Install::LogViewer::Filter::TimeDialog;
        };
        if ($@) {
           Wx::MessageBox( "Error: $@", 'Log Viewer Filter Error', wxOK | wxCENTRE | wxICON_EXCLAMATION, $self ); 
            return undef; # Stay in current dialog!
        } else {
            my ($frame) = SDB::Install::LogViewer::Filter::TimeDialog->new( "$filtername Filter", Wx::Point->new(300,100), Wx::Size->new(340,400), $cache, $self );
            $frame->ShowModal();
            $frame->Destroy();    
        }
    }
    1;
}


##
# Add filter to list.
#
# @param
#   AbstractFilter filter - filter
##

sub AddFilter () {
    my ($self, $filter) = @_;
    
    #Set ID for later identifikation
    $filter->SetID(++$filtercounter);
    $filter->SetEnable(1);
    
    #push it on the filter stack
    push @{$self->{FILTERSTACK}}, $filter;
    
    1;
}


##
# Apply all known added filter to the tree
# for filtering.
#
# @param
#   XLVTreeCtrl xlvtree - content tree
#   Cache cache         - cache
##

sub ApplyAllFilterNow() {
    my ($self, $xlvtree, $cache) = @_;

    return unless $self->{FILTERSTACK};

    my @list = @{$self->{FILTERSTACK}};

    # Reset cache nodes filter attribute
    $cache->ResetFilterAttributes();

    # Start every filter
    foreach my $filter (@list) {
        if ($filter->IsEnable() eq 1) {
            $filter->Filter( $cache->GetCacheTree() );            
        }
    }

    # Start to force set parent filter attributes
    $cache->SetRequiredToParentsFilterAttributes();
    
    # Compare cache with wxTree
    $self->compareWxTreeWithCache( $xlvtree, $xlvtree->GetRootItem() , $cache->GetCacheTree() );
    
    1;
}


##
# Compare the full xlvtree with cache tree. Add and remove leafs and so on.
#
# @param
#   XLVTreeCtrl xlvtree            - content tree
#   Wx::TreeCtrl xlvtreeParentNode - xlv tree node 
#   CacheTree cacheTree            - cache tree
##

sub compareWxTreeWithCache {
    my ($self, $xlvtree, $xlvtreeParentNode, $cacheTree ) = @_;
 
    # prepare to fight
    my $xlvParentData = $xlvtree->GetPlData ( $xlvtreeParentNode );
    
    my $cacheParentNode = $cacheTree->GetItemById( $xlvParentData->{id} );
    my $cacheParentData = $cacheTree->GetPlData ( $cacheParentNode );
    
    my @deleteTheChildrenInThisStack;
    # add and remove children
    # has children and expand in cache?
    if (($cacheTree->HasChildren ( $cacheParentNode )) && ($cacheParentData->{'Expand'} == 1)) {

        my ($cacheChildItem, $cookiecache) = $cacheTree->GetFirstChild ( $cacheParentNode );
        my ($xlvChildItem, $cookiexlv) = $xlvtree->GetFirstChild ( $xlvtreeParentNode );
        my $childcounter = 0;
        # compare children
        while ( defined $cacheChildItem ) {
            my $skipNextXLVChild = 0;
            my $cacheChildData = $cacheTree->GetPlData ( $cacheChildItem );
            if ($cacheChildData->{filter} eq 'Require') {
                # create, if not there
                if ($xlvChildItem->IsOk()) {
                    my $xlvChildData = $xlvtree->GetPlData ( $xlvChildItem );
                    
                    if ($cacheTree->GetItemId( $cacheChildItem ) == $xlvChildData->{id}) {
                        # nothing, because Item is there
                    } else {
                        # insert child before the current node
                        my $newItem = $xlvtree->InsertItem($xlvtreeParentNode, $childcounter, $cacheTree->GetItemText( $cacheChildItem ));
                        $xlvtree->SetPlData($newItem, $cacheTree->GetPlData( $cacheChildItem ));
                        if ($cacheChildItem->HasChildren) { $xlvtree->SetItemHasChildren($newItem,1); }
                        $skipNextXLVChild = 1;
                        $childcounter++;
                    }
                    
                } else {
                    # create child
                    my $newItem = $xlvtree->AppendItem($xlvtreeParentNode, $cacheTree->GetItemText( $cacheChildItem ));
                    $xlvtree->SetPlData($newItem, $cacheTree->GetPlData( $cacheChildItem ));
                    if ($cacheChildItem->HasChildren) { $xlvtree->SetItemHasChildren($newItem,1); }
                    $skipNextXLVChild = 1;
                    $childcounter++;
                }
            } elsif ($cacheChildData->{filter} eq 'Exclude') {
                # delete, if there
                if ($xlvChildItem->IsOk()) {
                    my $xlvChildData = $xlvtree->GetPlData ( $xlvChildItem );
                    if ($cacheTree->GetItemId( $cacheChildItem ) == $xlvChildData->{id}) {
                        push @deleteTheChildrenInThisStack, $xlvChildItem;
                    } else {
                        $skipNextXLVChild = 1;
                    }
                } else {
                    $skipNextXLVChild = 1;
                }                
            }
            ($cacheChildItem, $cookiecache) = $cacheTree->GetNextChild ( $cacheParentNode, $cookiecache);
            if ($skipNextXLVChild == 0) {
                ($xlvChildItem, $cookiexlv) = $xlvtree->GetNextChild ( $xlvtreeParentNode, $cookiexlv);
                $childcounter++;
            }
        }
        
        # Delete Children
        foreach my $child (@deleteTheChildrenInThisStack) {
            $xlvtree->Delete( $child );
        }
    }
    
    # traverse on these children
    my ($xlvChildItem, $cookiexlv) = $xlvtree->GetFirstChild ( $xlvtreeParentNode );
    while ( $xlvChildItem->IsOk() ) {
        $self->compareWxTreeWithCache($xlvtree, $xlvChildItem,$cacheTree );
        ($xlvChildItem, $cookiexlv) = $xlvtree->GetNextChild ( $xlvtreeParentNode, $cookiexlv);        
    }
        
    1; 
}


##
# Returns a table of filter attributes.
#
# @return
#   array of hash with filter informations.
##

sub GetFilterTable() {
    my ($self) = @_;
    my @table = ();
    
    return @table unless $self->{FILTERSTACK};
    
    my @list = @{$self->{FILTERSTACK}};
    
    return @table if (scalar @list eq 0);
    
    foreach my $filter (@list) {
        push @table, {
            'CATEGORY' => $filter->GetCatergory(),
            'FILTER' => $filter->ToString(),
            'ENABLE' => $filter->IsEnable(),
            'ID' => $filter->GetID(),
        };
    }
    
    return @table;
}


##
# Destroy all known filter.
##

sub DestroyAllFilters() {
    my ($self) = @_;
     
    return unless $self->{FILTERSTACK};
    
    while (scalar @{$self->{FILTERSTACK}} >0 ) {
        my $filter = pop @{$self->{FILTERSTACK}};
        $filter->DESTROY;
    }
    
    1;
}


##
# Destroy sepcific filter.
#
# @param
#   scalar id - filter id
##

sub DestroyFilter() {
    my ($self,$id) = @_;
    
    return unless $self->{FILTERSTACK};
    
    my @list = @{$self->{FILTERSTACK}};
    
    return if (scalar @list eq 0);
    my $count=0;
    foreach my $filter (@list) {
        if ($filter->GetID() eq $id) {
            $myfilter = splice @{$self->{FILTERSTACK}}, $count, 1;
            $myfilter->DESTROY;
        }
        $count++;
    }
    
    1;
}


##
# Switch enable status of specific filter.
#
# @param
#   scalar id - filter id
##

sub SwitchEnable() {
    my ($self,$id) = @_;
    
    return unless $self->{FILTERSTACK};
    
    my @list = @{$self->{FILTERSTACK}};
    
    return if (scalar @list eq 0);

    foreach my $filter (@list) {
        if ($filter->GetID() eq $id) {
            $filter->SetEnable(!$filter->IsEnable()); #switch
        }
    }
    
    1;
}

1;