#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#
# Desc: Save Element.

package SDB::Install::LogViewer::Type::CacheTree;

use strict;
use SDB::Install::LogViewer::Type::TreeElement;

sub new () {
    my $invocant = shift;
    my $class = ref ($invocant) || $invocant;
    my $self = {
        id => 0,
    };
    return bless ($self, $class);
}

sub AddRoot {
    my ($self, $text, $data) = @_;
    $self->{id}++;
    $data->{id} = $self->{id};
    $self->{root} = SDB::Install::LogViewer::Type::TreeElement->new ( 'ROOT', $text, $data, $self->{id} );
    $self->{nodecache}->[$self->{id}] = $self->{root};
    return $self->{root};
}

sub AppendItem {
    my ($self, $parent, $text, $data) = @_;
    $self->{id}++;
    my $child = SDB::Install::LogViewer::Type::TreeElement->new ( $parent, $text, $data, $self->{id} );
    $data->{id} = $self->{id};
    $self->{nodecache}->[$self->{id}] = $child;
    $parent->AddChild ($child);
    return $child;
}

sub GetNodeCache {
	return $_[0]->{nodecache};
}

sub SetItemText {
    my ($self, $item, $text) = @_;
    $item->SetText ($text);
}

sub SetPlData {
    my ($self, $item, $data) = @_;
    $item->SetData ($data);
}

sub GetItemById () {
	return $_[0]->{nodecache}->[$_[1]];
}

sub GetRootItem {
	return $_[0]->{root};
}

sub GetItemId {
	return $_[1]->{id};
}

sub GetItemText {
    return $_[1]->{text};
}

sub GetPlData {
	return $_[1]->{data};
}

#return 1 if node is filtered out, othwerwise 0
sub IsFiltered () {
    my ($self, $item ) = @_;
    #my $data = $self->GetPlData($item);
    my $data = $item->{data};
	return 1 if (!defined $data);
    return !((!exists $data->{filter}) || ($data->{filter} eq '') || ($data->{filter} eq 'Require'));
}

sub GetItemParent {
    my ($self, $item ) = @_;
    $item->GetParent();
}

sub GetFirstChild {
    my ($self, $item ) = @_;
    my $rc = $item->GetChildByNr(0);
    my @list = ($rc,1);
    return @list;
}

sub HasChildren {
    my ($self, $item ) = @_;
    return $item->HasChildren;
}

sub GetNextChild {
    my ($self, $item, $nr ) = @_;
    return ($item->GetChildByNr($nr),$nr+1);
}

sub GetLastChild {
    my ($self, $item ) = @_;
    $item->GetLastChild();
}

sub DeleteAllItems {
	my ($self) = @_;
   
	#
	# Double linked list prevents destruction through refcount.
    # Break one link here.
    #
    
    foreach my $element (@{$self->{nodecache}}){
		delete $element->{parent}; 
    } 
   
    delete $self->{root};
    delete $self->{nodecache};
}

sub GetNextSibling {
    my ($self, $node) = @_;
    my $parent = $node->GetParent();
    return undef if (!defined $parent);
    my $number = $parent->NrOfChild($node);
    if ($number == -1) { return undef; }
    return $parent->GetChildByNr(++$number);
}

sub GetPrevSibling {
    my ($self, $node) = @_;
    
    my $parent = $node->GetParent();
    
    if (!defined $parent) { return undef; }
    if ($parent eq 'ROOT') { return undef; }
    
    my $number = $parent->NrOfChild($node);
    # 0 is a child, but have no prev child. -1 is error code
    if ($number < 1) { return undef; }
    
    
    $number -= 1;
    my $result = $parent->GetChildByNr($number);
    return $result;
}

sub GetNextVisible {
    my ($self, $node) = @_;
    return $self->GetItemById( $node->GetId()+1 );
}

sub DESTROY{
	$_[0]->DeleteAllItems ();
}


1;