package SDB::Install::Manifest::OneOrTwoDigitReleaseManifest;

#
# components, that have changed its version schema from 1 digit release (e.g. '2')
# to two digit release (e.g. '2.0') or vice versa, should use this manifest class
#

use strict;

use base 'SDB::Install::Manifest';

sub getVersionObject{
    require SDB::Install::ComponentVersion;
    my ($self) = @_;
    my $release  = $self->getValue('release') // '0';
    my $revision = $self->getValue('rev-number') // $self->getValue('sp-number');
    my $patch    = $self->getValue('rev-patchlevel') // $self->getValue('sp-patchlevel') // '00';
    my $change   = $self->getValue('rev-changelist');

    my @releasePair = split('\.', $release);

    if (@releasePair == 1){
        push @releasePair, '0';
    }
    return new SDB::Install::ComponentVersion(@releasePair, $revision, $patch, $change);
}

1;
