package SDB::Install::P2Director;

use strict;
use SDB::Install::System qw (exec_program);
use SDB::Install::SysVars;
use SDB::Install::DebugUtilities qw (dumpThings);
use base qw (SDB::Install::BaseLegacy);


sub new{
    my $self = shift->SUPER::new();
    ($self->{instRoot}) = @_;
    $self->{eclipseExe} = 'director' . $path_separator . 'eclipse' . ($isWin ? '.exe' : '');
    return $self;
}

sub setEclipseExe{
    $_[0]->{eclipseExe} = $_[1];
}

sub setJavaVm{
    $_[0]->{javaVm} = $_[1];
}

sub setRepository{
    $_[0]->{repository} = $_[1];
}

sub is64Bit{
    my ($self) = @_;
    if (!defined $self->{is64Bit}){
        require SAPDB::Install::BuildInfo;
        my $exe = $self->{instRoot} . $path_separator . $self->{eclipseExe};
        my $magic = SAPDB::Install::BuildInfo::GetMagicString ($exe);
        if (!$magic){
            return undef;
        }
        $self->{is64Bit} = $magic =~ /AMD64|X86-64/;
    }
    return $self->{is64Bit};
}

sub callDirector{
    my ($self, $args, $msglst) = @_;

	if (!defined $msglst){
		$msglst = $self;
    }


    my $exe = $self->{instRoot} . $path_separator . $self->{eclipseExe};
    if (!-f $exe){
        $self->AddError ("Executable '$exe' not found");
        return undef;
    }
    my $is64bit = $self->is64Bit ();
    my @args = (
        ($self->{javaVm} ? ('-vm', $self->{javaVm}) : ()),
         @$args,
        '-profileProperties', 'org.eclipse.update.install.features=true',
        '-destination', $self->{instRoot},
        '-p2.os',($isWin ? 'win32' : $isApple ? 'macosx' :'linux'),
        '-p2.ws',($isWin ? 'win32' : $isApple ? 'cocoa' : 'gtk'),
        '-p2.arch', ($is64bit ? 'x86_64': 'x86'),
        '-roaming',
        '-vmargs', "-Declipse.p2.data.area=$self->{instRoot}${path_separator}p2");
    my $cfg = {};
	# replace backslashes with forward slashes
    foreach (@args) {
        s/\\/\//g;
    }
    my $rc =  exec_program ($exe, \@args, $cfg);
    if (defined $msglst){
        $msglst->AddMessage (undef, $cfg);
    }
    return $rc;
}

sub install{
    my ($self, $installableUnits, $msglst) = @_;

	if (!defined $msglst){
		$msglst = $self;
    }

    if (!defined $installableUnits || !@$installableUnits){
        $self->AddError ("No installable units defined");
        return undef;
    }

    my $msg = $msglst->AddMessage ("Installing units " . join (', ', @$installableUnits));
    my $submsglst = new SDB::Install::MsgLst ();
    my $rc = $self->callDirector (
        [
            '-installIU', join (',', @$installableUnits),
            '-repository', $self->{repository}
        ], $submsglst);
    $msglst->AddSubMsgLst ($msg, $submsglst);
    return $rc;
}

sub update{
    my ($self, $installableUnits) = @_;
    if (!defined $installableUnits || !@$installableUnits){
        $self->AddError ("No installable units defined");
        return undef;
    }

    my $msg = $self->AddMessage ("Updating units " . join (', ', @$installableUnits));
    my $msglst = new SDB::Install::MsgLst ();
    my $units = join (',', @$installableUnits);
    my $rc = $self->callDirector (
        [
            '-uninstallIU', $units,
            '-installIU', $units,
            '-repository', $self->{repository}
        ], $msglst);
    $self->AddSubMsgLst ($msg, $msglst);
    return $rc;

}


sub uninstall{
    my ($self, $installableUnits) = @_;
    if (!defined $installableUnits || !@$installableUnits){
        $self->AddError ("No installable units defined");
        return undef;
    }
    my $msg = $self->AddMessage ("Uninstalling units " . join (', ', @$installableUnits));
    my $msglst = new SDB::Install::MsgLst ();
    my $rc = $self->callDirector (
        [
            '-uninstallIU', join (',', @$installableUnits),
            '-repository', $self->{repository},
        ], $msglst);
    $self->AddSubMsgLst ($msg, $msglst);
    return $rc;

}


1;


